/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.metatileentity.logistics;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.api.metatileentity.logistics.IDelegator;

public abstract class MetaTileEntityDelegator
extends MetaTileEntity
implements IDelegator {
    protected final Predicate<Capability<?>> capFilter;
    protected final int baseColor;

    public MetaTileEntityDelegator(ResourceLocation metaTileEntityId, Predicate<Capability<?>> capFilter, int baseColor) {
        super(metaTileEntityId);
        this.capFilter = capFilter;
        this.baseColor = baseColor;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        T delegatedCapability = this.getDelegatedCapability(capability, side);
        return delegatedCapability == null ? this.getDefaultCapability(capability, side) : delegatedCapability;
    }

    protected <T> T getDefaultCapability(Capability<T> capability, EnumFacing side) {
        return (T)(side != null && this.capFilter.test(capability) && DefaultCapabilities.hasCapability(capability) ? DefaultCapabilities.getCapability(capability) : super.getCapability(capability, side));
    }

    protected <T> T getDelegatedCapability(Capability<T> capability, EnumFacing side) {
        MetaTileEntityHolder holder;
        if (capability == null || !this.capFilter.test(capability) || side == null) {
            return null;
        }
        EnumFacing delegatingFacing = this.getDelegatingFacing(side);
        if (delegatingFacing == null) {
            return null;
        }
        TileEntity te = this.getWorld().func_175625_s(this.getPos().func_177972_a(delegatingFacing));
        if (te == null || te instanceof MetaTileEntityHolder && (holder = (MetaTileEntityHolder)te).getMetaTileEntity() instanceof IDelegator) {
            return null;
        }
        return (T)te.getCapability(capability, delegatingFacing.func_176734_d());
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] colouredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.getPaintingColorForRendering())));
        for (EnumFacing facing : EnumFacing.values()) {
            Textures.renderFace((CCRenderState)renderState, (Matrix4)translation, (IVertexOperation[])colouredPipeline, (EnumFacing)facing, (Cuboid6)Cuboid6.full, (TextureAtlasSprite)this.getBaseTexture(), (BlockRenderLayer)BlockRenderLayer.CUTOUT_MIPPED);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected TextureAtlasSprite getBaseTexture() {
        return Textures.PIPE_SIDE;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.delegator.tooltip.non_recursion", (Object[])new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)this.getBaseTexture(), (Object)this.getPaintingColorForRendering());
    }

    public int getDefaultPaintingColor() {
        return this.baseColor;
    }

    protected boolean openGUIOnRightClick() {
        return false;
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    public static class DefaultCapabilities {
        private static final Object2ObjectArrayMap<Capability<?>, ?> DEFAULT_CAPABILITIES = new Object2ObjectArrayMap();

        public static boolean hasCapability(@NotNull Capability<?> capability) {
            return DEFAULT_CAPABILITIES.containsKey(capability);
        }

        @Nullable
        public static <T> T getCapability(@NotNull Capability<T> capability) {
            return (T)DEFAULT_CAPABILITIES.getOrDefault(capability, null);
        }

        public static <T> void addCapability(@NotNull Capability<T> capability, @NotNull T value) {
            DEFAULT_CAPABILITIES.put(capability, capability.cast(value));
        }

        static {
            DefaultCapabilities.addCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (IItemHandler)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new ItemStackHandler(1){

                @NotNull
                public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                    return stack;
                }

                @NotNull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    return ItemStack.field_190927_a;
                }
            }));
            DefaultCapabilities.addCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (IFluidHandler)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidTank(10000){

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drainInternal(int maxDrain, boolean doDrain) {
                    return null;
                }
            }));
            DefaultCapabilities.addCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, (IEnergyContainer)GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)IEnergyContainer.DEFAULT));
        }
    }
}

