/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.capability.impl;

import gregtech.api.capability.IDistillationTower;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.DistillationTowerLogicHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.util.GTLog;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;

public class ExtendedDTLogicHandler
extends DistillationTowerLogicHandler {
    protected static final DistillationTowerLogicHandler.FakeTank BLACK_HOLE = new DistillationTowerLogicHandler.FakeTank(){};
    protected final Function<Integer, Integer> offsetCounter;
    protected final int outputLayerIndex;

    public ExtendedDTLogicHandler(IDistillationTower tower, int outputLayerIndex, Function<Integer, Integer> offsetCounter) {
        super(tower);
        this.outputLayerIndex = outputLayerIndex;
        this.offsetCounter = offsetCounter;
    }

    public void determineLayerCount(@NotNull BlockPattern structurePattern) {
        this.setLayerCount(structurePattern.formedRepetitionCount[this.outputLayerIndex]);
    }

    public void determineOrderedFluidOutputs() {
        List fluidExportParts = this.tower.getMultiblockParts().stream().filter(iMultiblockPart -> {
            IMultiblockAbilityPart abilityPart;
            return iMultiblockPart instanceof IMultiblockAbilityPart && (abilityPart = (IMultiblockAbilityPart)iMultiblockPart).getAbility() == MultiblockAbility.EXPORT_FLUIDS && abilityPart instanceof MetaTileEntityMultiblockPart;
        }).map(iMultiblockPart -> (MetaTileEntityMultiblockPart)iMultiblockPart).collect(Collectors.toList());
        ObjectArrayList orderedHandlerList = new ObjectArrayList();
        ObjectArrayList tankList = new ObjectArrayList();
        int firstY = this.tower.getPos().func_177956_o() + this.offsetCounter.apply(this.getLayerCount());
        int exportIndex = 0;
        for (int y = firstY; y < firstY + this.getLayerCount(); ++y) {
            if (fluidExportParts.size() <= exportIndex) {
                orderedHandlerList.add(BLACK_HOLE);
                tankList.add(BLACK_HOLE);
                continue;
            }
            MetaTileEntityMultiblockPart part = (MetaTileEntityMultiblockPart)fluidExportParts.get(exportIndex);
            if (part.getPos().func_177956_o() == y) {
                ObjectArrayList hatchTanks = new ObjectArrayList();
                ((IMultiblockAbilityPart)part).registerAbilities((List)hatchTanks);
                orderedHandlerList.add(new FluidTankList(false, (List)hatchTanks));
                tankList.addAll(hatchTanks);
                ++exportIndex;
                continue;
            }
            if (part.getPos().func_177956_o() > y) {
                orderedHandlerList.add(BLACK_HOLE);
                tankList.add(BLACK_HOLE);
                continue;
            }
            GTLog.logger.error("The Distillation Tower at {} had a fluid export hatch with an unexpected Y position.", (Object)this.tower.getPos());
            this.tower.invalidateStructure();
            this.setOrderedFluidOutputs((List)new ObjectArrayList());
            this.setFluidTanks((IMultipleTankHandler)new FluidTankList(false, new IFluidTank[0]));
        }
        this.setOrderedFluidOutputs((List)orderedHandlerList);
        this.setFluidTanks((IMultipleTankHandler)new FluidTankList(this.tower.allowSameFluidFillForOutputs(), (List)tankList));
    }
}

