/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.blocks;

import gregtech.api.block.VariantBlock;
import gregtech.api.cover.CoverRayTracer;
import gregtech.common.items.tool.rotation.CustomBlockRotations;
import gregtech.common.items.tool.rotation.ICustomRotationBehavior;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class VariantAxialRotatableBlock<T extends Enum<T>>
extends VariantBlock<T> {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    public static final ICustomRotationBehavior BLOCK_AXIAL_BEHAVIOR = (state, world, pos, hitResult) -> {
        EnumFacing gridSide = CoverRayTracer.determineGridSideHit((RayTraceResult)hitResult);
        if (gridSide == null) {
            return false;
        }
        EnumFacing.Axis axis = gridSide.func_176740_k();
        if (axis != state.func_177229_b(AXIS)) {
            state = state.func_177226_a(AXIS, (Comparable)axis);
            world.func_175656_a(pos, state);
            return true;
        }
        return false;
    };

    public VariantAxialRotatableBlock(Material materialIn) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.VARIANT, (Comparable)((Object)this.VALUES[0])).func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X));
        CustomBlockRotations.registerCustomRotation((Block)this, (ICustomRotationBehavior)BLOCK_AXIAL_BEHAVIOR);
    }

    @Nonnull
    public IBlockState func_180642_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @NotNull EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(AXIS, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer).func_176740_k());
    }

    public ItemStack getItemVariant(T variant, int amount) {
        return new ItemStack((Block)this, amount, ((Enum)variant).ordinal() * 3);
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        Class enumClass = VariantAxialRotatableBlock.getActualTypeParameter(((Object)((Object)this)).getClass(), VariantAxialRotatableBlock.class);
        this.VARIANT = PropertyEnum.func_177709_a((String)"variant", (Class)enumClass);
        this.VALUES = (Enum[])enumClass.getEnumConstants();
        return new BlockStateContainer((Block)this, new IProperty[]{this.VARIANT, AXIS});
    }

    public int func_180651_a(@NotNull IBlockState state) {
        return ((Enum)((Object)state.func_177229_b((IProperty)this.VARIANT))).ordinal() * 3;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int i = meta / 3;
        int j = meta % 3;
        EnumFacing.Axis axis = EnumFacing.Axis.values()[j];
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)axis).func_177226_a((IProperty)this.VARIANT, (Comparable)((Object)this.VALUES[i % this.VALUES.length]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b((IProperty)this.VARIANT))).ordinal() * 3 + ((EnumFacing.Axis)state.func_177229_b(AXIS)).ordinal();
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, @NotNull RayTraceResult target, @NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer player) {
        return this.getItemVariant((Enum)((Object)state.func_177229_b((IProperty)this.VARIANT)), 1);
    }

    public boolean rotateBlock(World world, @NotNull BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing.Axis currentAxis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (currentAxis == axis.func_176740_k()) {
            return false;
        }
        world.func_175656_a(pos, state.func_177226_a(AXIS, (Comparable)axis.func_176740_k()));
        return true;
    }
}

