/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;

public abstract class TagMouseOver
extends Tag {
    @Override
    public String getCategory() {
        return "mouseover";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new Name().setName("mouseovername"));
        TagRegistry.INSTANCE.register(new UniqueName().setName("mouseoveruniquename"));
        TagRegistry.INSTANCE.register(new Id().setName("mouseoverid"));
        TagRegistry.INSTANCE.register(new Metadata().setName("mouseovermetadata"));
        TagRegistry.INSTANCE.register(new PowerWeak().setName("mouseoverpowerweak"));
        TagRegistry.INSTANCE.register(new PowerStrong().setName("mouseoverpowerstrong"));
        TagRegistry.INSTANCE.register(new PowerInput().setName("mouseoverpowerinput"));
    }

    public static class PowerInput
    extends TagMouseOver {
        @Override
        public String getValue() {
            RayTraceResult objectMouseOver = PowerInput.minecraft.field_71476_x;
            if (objectMouseOver != null && objectMouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                return String.valueOf(world.func_175687_A(objectMouseOver.func_178782_a()));
            }
            return "-1";
        }
    }

    public static class PowerStrong
    extends TagMouseOver {
        @Override
        public String getValue() {
            RayTraceResult objectMouseOver = PowerStrong.minecraft.field_71476_x;
            if (objectMouseOver != null && objectMouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                EnumFacing side;
                BlockPos pos = objectMouseOver.func_178782_a();
                IBlockState blockState = world.func_180495_p(pos);
                int power = -1;
                EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
                int n = enumFacingArray.length;
                for (int i = 0; i < n && (power = Math.max(power, blockState.func_185893_b((IBlockAccess)world, pos, side = enumFacingArray[i]))) < 15; ++i) {
                }
                return String.valueOf(power);
            }
            return "-1";
        }
    }

    public static class PowerWeak
    extends TagMouseOver {
        @Override
        public String getValue() {
            RayTraceResult objectMouseOver = PowerWeak.minecraft.field_71476_x;
            if (objectMouseOver != null && objectMouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                int power = -1;
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    BlockPos pos = objectMouseOver.func_178782_a().func_177972_a(side);
                    IBlockState blockState = world.func_180495_p(pos);
                    if ((power = Math.max(power, blockState.func_185911_a((IBlockAccess)world, pos, side))) >= 15) break;
                }
                return String.valueOf(power);
            }
            return "-1";
        }
    }

    public static class Metadata
    extends TagMouseOver {
        @Override
        public String getValue() {
            RayTraceResult objectMouseOver = Metadata.minecraft.field_71476_x;
            if (objectMouseOver != null && objectMouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState blockState = world.func_180495_p(objectMouseOver.func_178782_a());
                return String.valueOf(blockState.func_177230_c().func_176201_c(blockState));
            }
            return "0";
        }
    }

    public static class Id
    extends TagMouseOver {
        @Override
        public String getValue() {
            RayTraceResult objectMouseOver = Id.minecraft.field_71476_x;
            if (objectMouseOver != null) {
                if (objectMouseOver.field_72313_a == RayTraceResult.Type.ENTITY) {
                    return String.valueOf(objectMouseOver.field_72308_g.func_145782_y());
                }
                if (objectMouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                    Block block = world.func_180495_p(objectMouseOver.func_178782_a()).func_177230_c();
                    return String.valueOf(Block.field_149771_c.func_148757_b((Object)block));
                }
            }
            return "0";
        }
    }

    public static class UniqueName
    extends TagMouseOver {
        @Override
        public String getValue() {
            RayTraceResult objectMouseOver = UniqueName.minecraft.field_71476_x;
            if (objectMouseOver != null) {
                if (objectMouseOver.field_72313_a == RayTraceResult.Type.ENTITY) {
                    String name = EntityList.func_75621_b((Entity)objectMouseOver.field_72308_g);
                    if (name != null) {
                        return name;
                    }
                } else if (objectMouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                    Block block = world.func_180495_p(objectMouseOver.func_178782_a()).func_177230_c();
                    return String.valueOf(Block.field_149771_c.func_177774_c((Object)block));
                }
            }
            return "";
        }
    }

    public static class Name
    extends TagMouseOver {
        @Override
        public String getValue() {
            RayTraceResult objectMouseOver = Name.minecraft.field_71476_x;
            if (objectMouseOver != null) {
                if (objectMouseOver.field_72313_a == RayTraceResult.Type.ENTITY) {
                    return objectMouseOver.field_72308_g.func_145748_c_().func_150254_d();
                }
                if (objectMouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                    IBlockState blockState = world.func_180495_p(objectMouseOver.func_178782_a());
                    Block block = blockState.func_177230_c();
                    ItemStack pickBlock = block.getPickBlock(blockState, objectMouseOver, world, objectMouseOver.func_178782_a(), (EntityPlayer)player);
                    return pickBlock.func_82833_r();
                }
            }
            return "";
        }
    }
}

