/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.ic2.zpm.modulehub;

import gcewing.sg.SGCraft;
import gcewing.sg.client.gui.SGScreen;
import gcewing.sg.features.ic2.zpm.modulehub.ZpmHubContainer;
import gcewing.sg.features.ic2.zpm.modulehub.ZpmHubTE;
import java.text.DecimalFormat;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ZpmHubScreen
extends SGScreen {
    static String screenTitle = "ZPM Hub";
    static final int guiWidth = 256;
    static final int guiHeight = 208;
    static final DecimalFormat dFormat = new DecimalFormat("###,###,###,##0");
    ZpmHubTE te;

    public static ZpmHubScreen create(EntityPlayer player, World world, BlockPos pos) {
        ZpmHubTE te = ZpmHubTE.at((IBlockAccess)world, pos);
        if (te != null) {
            return new ZpmHubScreen(player, te);
        }
        return null;
    }

    public ZpmHubScreen(EntityPlayer player, ZpmHubTE te) {
        super(new ZpmHubContainer(player, te), 256, 208);
        this.te = te;
    }

    @Override
    protected void drawBackgroundLayer() {
        this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/zpm_hub_gui.png"), 256, 256);
        this.drawTexturedRect(0.0, 0.0, 256.0, 208.0, 0.0, 0.0);
        int cx = this.field_146999_f / 2;
        this.setTextColor(19558);
        this.drawCenteredString(screenTitle, cx, 8);
        this.drawString("ZPM Slots", 123, 42);
        if (this.te.getZpmSlotsloaded() > 0) {
            this.drawString("IC2 Power Tier: " + dFormat.format(this.te.getZpmSlotsloaded() + 2), 60, 90);
        }
        if (this.te.getZpmSlotsloaded() > 1) {
            this.drawString("Optimization factor: x" + dFormat.format(this.te.getZpmSlotsloaded()), 60, 100);
        }
        this.drawString(I18n.func_135052_a((String)"sgcraft.gui.zpmConsole.label.availablePower", (Object[])new Object[0]) + ": " + dFormat.format(this.te.availableEnergy()), 60, 110);
    }
}

