/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.ic2.zpm.interfacecart;

import gcewing.sg.BaseTileInventory;
import gcewing.sg.BaseUtils;
import gcewing.sg.SGCraft;
import gcewing.sg.features.ic2.zpm.interfacecart.ZpmInterfaceCart;
import gcewing.sg.features.ic2.zpm.interfacecart.ZpmInterfaceCartBasicSource;
import gcewing.sg.features.zpm.ZPMItem;
import gcewing.sg.interfaces.ISGEnergySource;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.util.GateUtil;
import ic2.api.energy.prefab.BasicSource;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class ZpmInterfaceCartTE
extends BaseTileInventory
implements ISGEnergySource,
IEnergySource,
IInventory,
ITickable {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    public final BasicSource source = new ZpmInterfaceCartBasicSource(this, 2.147483647E9, 3);
    public static final int firstZpmSlot = 0;
    public static final int numZpmSlots = 1;
    public static final int numSlots = 1;
    private double energyPerSGEnergyUnit = 80.0;
    private int update = 0;

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.source.readFromNBT(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.source.writeToNBT(compound);
        return compound;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.source.update();
    }

    public void onChunkUnload() {
        this.source.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.source.invalidate();
    }

    @Override
    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound result = new NBTTagCompound();
        this.func_189515_b(result);
        return result;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound tag = packet.func_148857_g();
        this.func_145839_a(tag);
    }

    @Override
    public double availableEnergy() {
        return this.source.getEnergyStored();
    }

    @Override
    public double totalAvailableEnergy() {
        return this.source.getCapacity();
    }

    @Override
    public double drawEnergyDouble(double amount) {
        double available = this.source.getEnergyStored();
        double supply = BaseUtils.min(amount, available);
        this.source.drawEnergy(supply * this.energyPerSGEnergyUnit);
        if (this.isTainted(this.func_70301_a(0))) {
            this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0f, true, true);
        }
        this.markChanged();
        return supply;
    }

    public double getOfferedEnergy() {
        return this.source.getOfferedEnergy();
    }

    public void drawEnergy(double v) {
        this.source.drawEnergy(v);
        if (this.isTainted(this.func_70301_a(0))) {
            this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0f, true, true);
        }
        this.markChanged();
    }

    public int getSourceTier() {
        return this.source.getSourceTier();
    }

    public boolean emitsEnergyTo(IEnergyAcceptor iEnergyAcceptor, EnumFacing enumFacing) {
        if (this.isTainted(this.func_70301_a(0))) {
            this.field_145850_b.func_72885_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0f, true, true);
        }
        this.markChanged();
        return this.source.emitsEnergyTo(iEnergyAcceptor, enumFacing);
    }

    @Override
    public int func_70302_i_() {
        return 1;
    }

    @Override
    protected IInventory getInventory() {
        return this;
    }

    @Override
    public boolean func_191420_l() {
        for (ItemStack item : this.items) {
            if (item.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(0);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack item = ItemStackHelper.func_188382_a(this.items, (int)0, (int)1);
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            item.func_77982_d(tag);
        }
        if (tag.func_150297_b("AvailableEnergy", 99)) {
            tag.func_74780_a("AvailableEnergy", this.source.getEnergyStored());
            tag.func_74757_a("loadedIntoCart", false);
            this.source.setEnergyStored(0.0);
        }
        if (this.field_145850_b != null) {
            IBlockState other = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)ZpmInterfaceCart.ZPM_LOADED, (Comparable)Boolean.valueOf(false));
            this.field_145850_b.func_180501_a(this.field_174879_c, other, 3);
            this.markChanged();
        }
        if (this.func_191420_l()) {
            this.pingSGBaseTE();
        }
        return ItemStackHelper.func_188383_a(this.items, (int)0);
    }

    @Override
    public ItemStack func_70298_a(int index, int quantity) {
        ItemStack item = ItemStackHelper.func_188383_a(this.items, (int)0);
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            item.func_77982_d(tag);
        }
        if (tag != null && tag.func_150297_b("AvailableEnergy", 99)) {
            tag.func_74780_a("AvailableEnergy", this.source.getEnergyStored());
            tag.func_74757_a("loadedIntoCart", false);
            this.source.setEnergyStored(0.0);
        }
        if (this.field_145850_b != null) {
            IBlockState other = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)ZpmInterfaceCart.ZPM_LOADED, (Comparable)Boolean.valueOf(false));
            this.field_145850_b.func_180501_a(this.field_174879_c, other, 3);
            this.markChanged();
        }
        if (this.func_191420_l()) {
            this.pingSGBaseTE();
        }
        return item;
    }

    private void pingSGBaseTE() {
        TileEntity localGateTE;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && (localGateTE = GateUtil.locateLocalGate(this.field_145850_b, this.field_174879_c, SGCraft.zpmSearchRange, false)) instanceof SGBaseTE) {
            SGBaseTE localGate = (SGBaseTE)localGateTE;
            localGate.validateZPM();
        }
    }

    @Override
    public void func_70299_a(int index, ItemStack item) {
        this.items.set(0, (Object)item);
        if (ZpmInterfaceCartTE.isValidFuelItem(item)) {
            NBTTagCompound tag = item.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                item.func_77982_d(tag);
            }
            tag.func_74757_a("loadedIntoCart", true);
            if (!tag.func_150297_b("AvailableEnergy", 99)) {
                tag.func_74780_a("AvailableEnergy", 2.147483647E9);
                this.source.setCapacity(2.147483647E9);
                this.source.setEnergyStored(tag.func_74769_h("AvailableEnergy"));
            } else {
                this.source.setEnergyStored(tag.func_74769_h("AvailableEnergy"));
            }
        }
        if (this.field_145850_b != null) {
            IBlockState other = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)ZpmInterfaceCart.ZPM_LOADED, (Comparable)Boolean.valueOf(ZpmInterfaceCartTE.isValidFuelItem(item)));
            this.field_145850_b.func_180501_a(this.field_174879_c, other, 3);
            this.markChanged();
        }
    }

    public static boolean isValidFuelItem(ItemStack stack) {
        return stack != null && stack.func_77973_b() == SGCraft.zpm && stack.func_190916_E() > 0;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack item) {
        return item.func_77973_b() instanceof ZPMItem;
    }

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
        this.items.clear();
    }

    @Override
    public String func_70005_c_() {
        return "container.zero_point_module";
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TextComponentString("ZPM Container");
    }

    public static ZpmInterfaceCartTE at(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof ZpmInterfaceCartTE ? (ZpmInterfaceCartTE)te : null;
    }

    public boolean isTainted(ItemStack item) {
        boolean hasTaint = false;
        NBTTagList nbttaglist = item.func_77986_q();
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(j);
            short k = nbttagcompound.func_74765_d("id");
            short l = nbttagcompound.func_74765_d("lvl");
            Enchantment enchantment = Enchantment.func_185262_c((int)k);
            if (k != 51) continue;
            hasTaint = true;
        }
        return hasTaint;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

