/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.client.gui;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.SGCraft;
import gcewing.sg.client.gui.SGScreen;
import gcewing.sg.network.SGChannel;
import gcewing.sg.tileentity.DHDTE;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.util.SGAddressing;
import gcewing.sg.util.SGState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class DHDScreen
extends SGScreen {
    private final int dhdWidth = 320;
    private final int dhdHeight = 120;
    private final double dhdRadius1 = 32.0;
    private final double dhdRadius2 = 88.0;
    private final double dhdRadius3 = 144.0;
    private World world;
    private BlockPos pos;
    private DHDTE cte;
    private int dhdTop;
    private int dhdCentreX;
    private int dhdCentreY;
    private int closingDelay = 0;
    private int addressLength;
    private boolean debugDialing = false;

    public DHDScreen(EntityPlayer player, World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        this.cte = this.getControllerTE();
        SGBaseTE te = this.getStargateTE();
        if (te != null) {
            this.addressLength = te.getNumChevrons();
        }
    }

    private SGBaseTE getStargateTE() {
        return this.cte != null ? this.cte.getLinkedStargateTE() : null;
    }

    private DHDTE getControllerTE() {
        TileEntity te = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.world, this.pos);
        return te instanceof DHDTE ? (DHDTE)te : null;
    }

    private String getEnteredAddress() {
        return this.cte.enteredAddress;
    }

    private void setEnteredAddress(String address) {
        this.cte.enteredAddress = address;
    }

    @Override
    public void func_73866_w_() {
        this.dhdTop = this.field_146295_m - this.dhdHeight;
        this.dhdCentreX = this.field_146294_l / 2;
        this.dhdCentreY = this.dhdTop + this.dhdHeight / 2;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.closingDelay > 0 && --this.closingDelay == 0) {
            this.cte.enteredAddress = "";
            SGChannel.sendClearAddressToServer(this.cte);
            this.close();
        }
    }

    @Override
    protected void mousePressed(int x, int y, int mouseButton) {
        int i;
        if (mouseButton == 0 && (i = this.findDHDButton(x, y)) >= 0) {
            this.dhdButtonPressed(i);
        }
    }

    private void closeAfterDelay(int ticks) {
        this.closingDelay = ticks;
    }

    private int findDHDButton(int mx, int my) {
        int nb;
        int i0;
        int x = -(mx - this.dhdCentreX);
        int y = -(my - this.dhdCentreY);
        if (y > 0 && Math.hypot(x, y) <= this.dhdRadius1) {
            return 0;
        }
        double r = Math.hypot(x, y = y * this.dhdWidth / this.dhdHeight);
        if (r > this.dhdRadius3) {
            return -1;
        }
        if (r <= this.dhdRadius1) {
            return 0;
        }
        double a = Math.toDegrees(Math.atan2(y, x));
        if (a < 0.0) {
            a += 360.0;
        }
        if (r > this.dhdRadius2) {
            i0 = 1;
            nb = 26;
        } else {
            i0 = 27;
            nb = 11;
        }
        int i = i0 + (int)Math.floor(a * (double)nb / 360.0);
        System.out.printf("DHDScreen.findDHDButton: i = %d\n", i);
        return i;
    }

    private void dhdButtonPressed(int i) {
        if (i == 0) {
            this.dial();
        } else if (i >= 37) {
            this.erase();
        } else {
            this.chevron(SGBaseTE.symbolToChar(i - 1));
        }
    }

    private void buttonSound(SoundEvent sound) {
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        PositionedSoundRecord s = new PositionedSoundRecord(sound, SoundCategory.BLOCKS, 1.0f * SGBaseTE.soundVolume, 1.0f, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v);
        this.field_146297_k.func_147118_V().func_147682_a((ISound)s);
    }

    @Override
    protected void func_73869_a(char c, int key) {
        switch (key) {
            case 1: {
                this.close();
                break;
            }
            case 88: {
                break;
            }
            case 14: 
            case 211: {
                this.erase();
                break;
            }
            case 28: 
            case 156: {
                this.dial();
                break;
            }
            default: {
                String C = String.valueOf(c).toUpperCase();
                if (!SGAddressing.isValidSymbolChar(C)) break;
                this.chevron(C.charAt(0));
            }
        }
    }

    private void dial() {
        SGBaseTE te = this.getStargateTE();
        if (te != null) {
            if (te.gateType == 1) {
                this.buttonSound(SGBaseTE.m_dhdDialSound);
            } else {
                this.buttonSound(SGBaseTE.p_dhdDialSound);
            }
            this.sendConnectOrDisconnect(te, te.state == SGState.Idle ? this.getEnteredAddress() : "");
        }
    }

    private void sendConnectOrDisconnect(SGBaseTE te, String address) {
        if (this.debugDialing) {
            System.out.println("dial address: " + address);
        }
        SGChannel.sendConnectOrDisconnectToServer(te, address);
        this.closeAfterDelay(10);
    }

    private void erase() {
        if (this.stargateIsIdle()) {
            this.buttonSound(SoundEvents.field_187909_gi);
            String enteredAddress = this.getEnteredAddress();
            if (!enteredAddress.isEmpty()) {
                this.cte.unsetSymbol((EntityPlayer)this.field_146297_k.field_71439_g);
                SGChannel.sendUnsetSymbolToServer(this.cte);
            }
        }
    }

    private void chevron(char c) {
        if (this.stargateIsIdle()) {
            if (this.cte.getLinkedStargateTE().gateType == 1) {
                this.buttonSound(SGBaseTE.m_dhdPressSound);
            } else {
                this.buttonSound(SGBaseTE.p_dhdPressSound);
            }
            String a = this.getEnteredAddress();
            int n = a.length();
            if (n < this.addressLength) {
                this.cte.enterSymbol(null, c);
                SGChannel.sendEnterSymbolToServer(this.cte, c);
            }
        }
    }

    private boolean stargateIsIdle() {
        SGBaseTE te = this.getStargateTE();
        return te != null && te.state == SGState.Idle;
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        SGBaseTE te = this.getStargateTE();
        GL11.glPushAttrib((int)24576);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        this.drawBackgroundImage();
        this.drawButton();
        if (te != null && te.state == SGState.Idle) {
            this.drawEnteredSymbols();
            this.drawEnteredString();
        }
        GL11.glPopAttrib();
    }

    private void drawBackgroundImage() {
        this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/dhd_gui.png"));
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        this.drawTexturedRect((this.field_146294_l - 320) / 2, this.field_146295_m - 120, 320.0, 120.0);
    }

    private void drawButton() {
        boolean connected;
        SGBaseTE te = this.getStargateTE();
        boolean bl = connected = te != null && te.isActive();
        if (te.gateType == 2) {
            this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/pegasus_dhd_centre.png"), 128, 64);
        } else {
            this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/milkyway_dhd_centre.png"), 128, 64);
        }
        if (te == null || !te.isMerged) {
            this.setColor(0.2, 0.2, 0.2);
        } else if (connected) {
            if (te.gateType == 2) {
                this.setColor(0.0, 0.45, 1.0);
            } else {
                this.setColor(1.0, 0.5, 0.0);
            }
        } else if (te.gateType == 2) {
            this.setColor(0.0, 0.45, 0.8);
        } else {
            this.setColor(0.5, 0.25, 0.0);
        }
        double rx = (double)(this.dhdWidth * 48) / 512.0;
        double ry = (double)(this.dhdHeight * 48) / 256.0;
        this.drawTexturedRect((double)this.dhdCentreX - rx, (double)this.dhdCentreY - ry - 6.0, 2.0 * rx, 1.5 * ry, 64.0, 0.0, 64.0, 48.0);
        this.resetColor();
        if (connected) {
            GL11.glBlendFunc((int)1, (int)1);
            double d = 5.0;
            this.drawTexturedRect((double)this.dhdCentreX - rx - d, (double)this.dhdCentreY - ry - d - 6.0, 2.0 * (rx + d), ry + d, 0.0, 0.0, 64.0, 32.0);
            this.drawTexturedRect((double)this.dhdCentreX - rx - d, this.dhdCentreY - 6, 2.0 * (rx + d), 0.5 * ry + d, 0.0, 32.0, 64.0, 32.0);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    private void drawEnteredSymbols() {
        this.drawAddressSymbols(this.field_146294_l / 2, this.dhdTop - 80, this.getEnteredAddress());
    }

    private void drawEnteredString() {
        String address = SGAddressing.padAddress(this.getEnteredAddress(), "|", this.addressLength);
        this.drawAddressString(this.field_146294_l / 2, this.dhdTop - 20, address);
    }
}

