/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.client.gui;

import gcewing.sg.SGCraft;
import gcewing.sg.client.gui.SGScreen;
import gcewing.sg.container.DHDFuelContainer;
import gcewing.sg.tileentity.DHDTE;
import gcewing.sg.tileentity.SGBaseTE;
import java.text.DecimalFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class DHDFuelScreen
extends SGScreen {
    private final String screenTitle = "Stargate Controller";
    public static final int guiWidth = 256;
    public static final int guiHeight = 208;
    private final int fuelGaugeWidth = 16;
    private final int fuelGaugeHeight = 34;
    private final int fuelGaugeX = 214;
    private final int fuelGaugeY = 84;
    private final int fuelGaugeU = 0;
    private final int fuelGaugeV = 208;
    private final DecimalFormat dFormat = new DecimalFormat("###,###,###");
    private DHDTE te;
    private SGBaseTE baseTe;
    private double energyPerFuelItem;

    public static DHDFuelScreen create(EntityPlayer player, World world, BlockPos pos) {
        DHDTE te = DHDTE.at((IBlockAccess)world, pos);
        if (te != null) {
            return new DHDFuelScreen(player, te);
        }
        return null;
    }

    public DHDFuelScreen(EntityPlayer player, DHDTE te) {
        super(new DHDFuelContainer(player, te), 256, 208);
        this.te = te;
        this.baseTe = te.getLinkedStargateTE();
        if (this.baseTe != null) {
            this.energyPerFuelItem = this.baseTe.energyPerFuelItem;
        }
    }

    @Override
    protected void drawBackgroundLayer() {
        this.bindTexture(SGCraft.mod.resourceLocation("textures/gui/dhd_fuel_gui.png"), 256, 256);
        this.drawTexturedRect(0.0, 0.0, 256.0, 208.0, 0.0, 0.0);
        this.drawFuelGauge();
        int cx = this.field_146999_f / 2;
        this.setTextColor(19558);
        this.drawCenteredString(this.screenTitle, cx, 8);
        int naquadahUnits = this.te.getInventory().func_70301_a(0).func_190916_E() + this.te.getInventory().func_70301_a(1).func_190916_E() + this.te.getInventory().func_70301_a(2).func_190916_E() + this.te.getInventory().func_70301_a(3).func_190916_E();
        if (SGCraft.displayGuiPowerDebug) {
            if (this.baseTe != null) {
                this.drawRightAlignedString("Gate Buffer:", 125, 30);
                this.drawString(this.dFormat.format(Math.min(Math.max(this.baseTe.energyInBuffer, 0.0), this.baseTe.maxEnergyBuffer)) + " / " + this.baseTe.maxEnergyBuffer, 130, 30);
            }
            this.drawRightAlignedString("DHD Buffer:", 125, 40);
            this.drawString(this.dFormat.format(Math.min(Math.max(this.te.energyInBuffer, 0.0), this.te.maxEnergyBuffer)), 130, 40);
            this.drawRightAlignedString("Buffer Max:", 125, 50);
            this.drawString(this.dFormat.format(this.te.maxEnergyBuffer), 130, 50);
            this.drawRightAlignedString("Naquadah:", 125, 60);
            this.drawString(this.dFormat.format(naquadahUnits), 130, 60);
            this.drawRightAlignedString("Available Power Units:", 125, 70);
            this.drawString(this.dFormat.format((double)naquadahUnits * this.energyPerFuelItem), 130, 70);
        }
        if (4 > 0) {
            this.drawString("Fuel", 150, 96);
        }
    }

    private void drawFuelGauge() {
        int level = (int)((double)this.fuelGaugeHeight * this.te.energyInBuffer / this.te.maxEnergyBuffer);
        if (level > this.fuelGaugeHeight) {
            level = this.fuelGaugeHeight;
        }
        GL11.glEnable((int)3042);
        this.drawTexturedRect(this.fuelGaugeX, this.fuelGaugeY + this.fuelGaugeHeight - level, this.fuelGaugeWidth, level, this.fuelGaugeU, this.fuelGaugeV);
        GL11.glDisable((int)3042);
    }
}

