/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.block;

import gcewing.sg.BaseBlock;
import gcewing.sg.BaseMod;
import gcewing.sg.BaseOrientation;
import gcewing.sg.SGCraft;
import gcewing.sg.Vector3;
import gcewing.sg.block.SGBaseBlock;
import gcewing.sg.client.gui.SGGui;
import gcewing.sg.tileentity.DHDTE;
import gcewing.sg.tileentity.SGBaseTE;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DHDBlock
extends BaseBlock<DHDTE> {
    protected static String[] textures = new String[]{"dhd_top", "dhd_side", "stargateblock", "dhd_button_dim"};
    protected static BaseMod.ModelSpec model = new BaseMod.ModelSpec("block/dhd.smeg", new Vector3(0.0, -0.5, 0.0), textures);

    public DHDBlock() {
        super(Material.field_151576_e, DHDTE.class);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Override
    public String[] getTextureNames() {
        return textures;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState state) {
        return model;
    }

    @Override
    public BaseBlock.IOrientationHandler getOrientationHandler() {
        return BaseOrientation.orient4WaysByState;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("DHDBlock.onBlockAdded: at %d\n", pos);
        }
        this.checkForLink(world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.func_180633_a(world, pos, state, player, stack);
        this.checkForLink(world, pos);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return SGCraft.canHarvestDHD;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        SGBaseTE gte;
        DHDTE cte;
        if (!player.field_71075_bZ.field_75098_d && (cte = (DHDTE)this.getTileEntity((IBlockAccess)world, pos)) != null && cte.isLinkedToStargate && (gte = cte.getLinkedStargateTE()) != null && !gte.canPlayerBreakGate) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        SGBaseTE gte;
        DHDTE cte = (DHDTE)this.getTileEntity((IBlockAccess)world, pos);
        super.func_180663_b(world, pos, state);
        if (cte == null) {
            System.out.printf("DHDBlock.breakBlock: No tile entity at %s\n", pos);
        } else if (cte.isLinkedToStargate && (gte = cte.getLinkedStargateTE()) != null) {
            gte.clearLinkToController();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float cx, float cy, float cz) {
        SGBaseTE localGate;
        DHDTE localDHD = (DHDTE)this.getTileEntity((IBlockAccess)world, pos);
        if (localDHD != null && localDHD.isLinkedToStargate && (localGate = localDHD.getLinkedStargateTE()) != null) {
            if ((double)cy <= 0.5) {
                if (player != null && localGate.allowAdminAccess(player.func_70005_c_()) && !world.field_72995_K) {
                    SGCraft.mod.openGui(player, (Enum)SGGui.DHDFuel, world, pos);
                    return true;
                }
            } else if (world.field_72995_K) {
                if (player != null && localGate.allowGateAccess(player.func_70005_c_())) {
                    SGCraft.mod.openGui(player, (Enum)SGGui.SGController, world, pos);
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public void checkForLink(World world, BlockPos pos) {
        DHDTE te = (DHDTE)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            te.checkForLink();
        } else {
            System.out.printf("DHDBlock.breakBlock: No tile entity at %d\n", pos);
        }
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new DHDTE(DHDTE.cfgMaxEnergyBuffer);
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return SGCraft.canHarvestDHD;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

