/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseMod;
import gcewing.sg.BaseTileEntity;
import gcewing.sg.tileentity.SGBaseTE;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class BaseTEChunkManager
implements ForgeChunkManager.LoadingCallback {
    public boolean debug = false;
    BaseMod base;

    public BaseTEChunkManager(BaseMod mod) {
        this.base = mod;
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)mod, (ForgeChunkManager.LoadingCallback)this);
        if (this.debug) {
            System.out.printf("%s: BaseTEChunkManager: Chunk loading callback installed\n", this.base.modPackage);
        }
    }

    protected ForgeChunkManager.Ticket newTicket(World world) {
        if (this.debug) {
            System.out.printf("%s: BaseTEChunkManager.newTicket for %s\n", this.base.modPackage, world);
        }
        return ForgeChunkManager.requestTicket((Object)this.base, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        if (this.debug) {
            System.out.printf("%s: BaseTEChunkManager.ticketsLoaded for %s\n", this.base.modPackage, world);
        }
        for (ForgeChunkManager.Ticket ticket : tickets) {
            NBTTagCompound nbt = ticket.getModData();
            if (nbt == null || !nbt.func_74779_i("type").equals("TileEntity")) continue;
            int x = nbt.func_74762_e("xCoord");
            int y = nbt.func_74762_e("yCoord");
            int z = nbt.func_74762_e("zCoord");
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            if (this.debug) {
                System.out.printf("%s: BaseTEChunkManager.ticketsLoaded: Ticket for %s at (%d, %d, %d)\n", this.base.modPackage, te, x, y, z);
            }
            if (te instanceof BaseTileEntity && this.reinstateChunkTicket((BaseTileEntity)te, ticket)) continue;
            if (this.debug) {
                System.out.printf("%s: BaseTEChunkManager.ticketsLoaded: : Unable to reinstate ticket\n", this.base.modPackage);
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    public void setForcedChunkRange(BaseTileEntity te, int minX, int minZ, int maxX, int maxZ) {
        if (te instanceof SGBaseTE) {
            te.releaseChunkTicket();
            ForgeChunkManager.Ticket ticket = this.getChunkTicket(te);
            if (ticket != null) {
                BlockPos pos = te.func_174877_v();
                NBTTagCompound nbt = ticket.getModData();
                nbt.func_74778_a("type", "TileEntity");
                nbt.func_74768_a("xCoord", pos.func_177958_n());
                nbt.func_74768_a("yCoord", pos.func_177956_o());
                nbt.func_74768_a("zCoord", pos.func_177952_p());
                nbt.func_74768_a("rangeMinX", minX);
                nbt.func_74768_a("rangeMinZ", minZ);
                nbt.func_74768_a("rangeMaxX", maxX);
                nbt.func_74768_a("rangeMaxZ", maxZ);
                this.forceChunkRangeOnTicket(te, ticket);
            } else {
                System.out.print("SGCraft: unable to create chunk ticket; this will likely cause issues with remote gates prematurely unloading at: " + te.func_174877_v() + " in world: " + te.func_145831_w().func_72912_H().func_76065_j());
            }
        }
    }

    public void clearForcedChunkRange(BaseTileEntity te) {
        te.releaseChunkTicket();
    }

    protected void forceChunkRangeOnTicket(BaseTileEntity te, ForgeChunkManager.Ticket ticket) {
        NBTTagCompound nbt = ticket.getModData();
        int minX = nbt.func_74762_e("rangeMinX");
        int minZ = nbt.func_74762_e("rangeMinZ");
        int maxX = nbt.func_74762_e("rangeMaxX");
        int maxZ = nbt.func_74762_e("rangeMaxZ");
        if (this.debug) {
            System.out.printf("BaseChunkLoadingTE: Forcing range (%s,%s)-(%s,%s) in dimension %s\n", minX, minZ, maxX, maxZ, te.func_145831_w().field_73011_w.getDimension());
        }
        BlockPos pos = te.func_174877_v();
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minZ; j <= maxZ; ++j) {
                int x = chunkX + i;
                int z = chunkZ + j;
                if (this.debug) {
                    System.out.println("Created chunk ticket at: " + x + "/" + z + " for: " + te + " with ticket: " + ticket);
                }
                if (ticket.world == null) {
                    System.out.println("World is null in chunk ticket!!!");
                    return;
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(x, z));
            }
        }
    }

    protected ForgeChunkManager.Ticket getChunkTicket(BaseTileEntity te) {
        if (te.chunkTicket == null) {
            te.chunkTicket = this.newTicket(te.func_145831_w());
        }
        return te.chunkTicket;
    }

    public boolean reinstateChunkTicket(BaseTileEntity te, ForgeChunkManager.Ticket ticket) {
        if (te.chunkTicket == null) {
            if (this.debug) {
                System.out.printf("BaseChunkLoadingTE: Reinstating chunk ticket %s\n", ticket);
            }
            te.chunkTicket = ticket;
            this.forceChunkRangeOnTicket(te, ticket);
            return true;
        }
        return false;
    }

    public void dumpChunkLoadingState(BaseTileEntity te, String label) {
        System.out.printf("%s: Chunk loading state:\n", label);
        System.out.printf("Chunk ticket = %s\n", te.chunkTicket);
        if (te.chunkTicket != null) {
            System.out.printf("Loaded chunks:", new Object[0]);
            for (Object item : te.chunkTicket.getChunkList()) {
                ChunkPos coords = (ChunkPos)item;
                System.out.printf(" (%d,%d)", coords.field_77276_a, coords.field_77275_b);
            }
            System.out.printf("\n", new Object[0]);
        }
    }
}

