/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseRenderTarget;
import gcewing.sg.Vector3;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.util.vector.Vector3f;

public class BaseBakedRenderTarget
extends BaseRenderTarget {
    protected static VertexFormat theFormat = new VertexFormat();
    protected static List<BakedQuad> emptyQuads;
    protected static Map<EnumFacing, List<BakedQuad>> faceQuads;
    protected VertexFormat format = theFormat;
    protected int bytesPerVertex = this.format.func_177338_f();
    protected int intsPerVertex = this.bytesPerVertex / 4;
    protected ByteBuffer buf = ByteBuffer.allocate(this.bytesPerVertex * 4);
    protected List<BakedQuad> quads = new ArrayList<BakedQuad>();
    protected static ItemTransformVec3f transThirdPerson;
    protected static ItemTransformVec3f transFirstPerson;
    protected static ItemTransformVec3f transOnHead;
    protected static ItemTransformVec3f transInGui;
    protected static ItemTransformVec3f transOnGround;
    protected static ItemTransformVec3f transFixed;
    protected static ItemCameraTransforms transforms;

    public BaseBakedRenderTarget() {
        this(0.0, 0.0, 0.0, null);
    }

    public BaseBakedRenderTarget(BlockPos pos) {
        this(pos, null);
    }

    public BaseBakedRenderTarget(TextureAtlasSprite overrideIcon) {
        this(0.0, 0.0, 0.0, overrideIcon);
    }

    public BaseBakedRenderTarget(BlockPos pos, TextureAtlasSprite overrideIcon) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), overrideIcon);
    }

    public BaseBakedRenderTarget(double x, double y, double z, TextureAtlasSprite overrideIcon) {
        super(x, y, z, overrideIcon);
    }

    @Override
    protected void setMode(int m) {
        super.setMode(m);
        this.buf.clear();
    }

    @Override
    public void endFace() {
        int n;
        super.endFace();
        this.buf.flip();
        int intsPerQuad = this.intsPerVertex * 4;
        int[] data = new int[intsPerQuad];
        IntBuffer intBuf = this.buf.asIntBuffer();
        intBuf.get(data, 0, n);
        for (n = intBuf.limit(); n < intsPerQuad; ++n) {
            data[n] = data[n - this.intsPerVertex];
        }
        this.prescrambleVertexColors(data);
        this.quads.add(new BakedQuad(data, 0, EnumFacing.UP, null));
    }

    protected void dumpVertexData(int[] data, int n) {
        System.out.printf("BaseBakedRenderTarget.endFace: Vertex data:\n", new Object[0]);
        for (int i = 0; i < 4; ++i) {
            int k = i * this.intsPerVertex;
            System.out.printf("[%s] coords (%.3f,%.3f,%.3f) color %08x\n", i, Float.valueOf(Float.intBitsToFloat(data[k])), Float.valueOf(Float.intBitsToFloat(data[k + 1])), Float.valueOf(Float.intBitsToFloat(data[k + 2])), data[k + 3]);
        }
    }

    protected void prescrambleVertexColors(int[] data) {
        int i;
        int[] c = new int[4];
        for (i = 0; i < 4; ++i) {
            c[i] = data[i * this.intsPerVertex + 3];
        }
        for (i = 0; i < 4; ++i) {
            data[i * this.intsPerVertex + 3] = c[3 - i];
        }
    }

    public IBakedModel getBakedModel() {
        return this.getBakedModel(null);
    }

    public IBakedModel getBakedModel(TextureAtlasSprite particleTexture) {
        if (this.verticesPerFace != 0) {
            throw new IllegalStateException("Rendering ended with incomplete face");
        }
        return new SimpleBakedModel(this.quads, faceQuads, false, true, particleTexture, transforms, ItemOverrideList.field_188022_a);
    }

    @Override
    protected void rawAddVertex(Vector3 p, double u, double v) {
        block6: for (VertexFormatElement e : this.format.func_177343_g()) {
            switch (e.func_177375_c()) {
                case POSITION: {
                    this.putElement(e, p.x, p.y, p.z);
                    continue block6;
                }
                case COLOR: {
                    this.putElement(e, Float.valueOf(this.alpha), Float.valueOf(this.blue), Float.valueOf(this.green), Float.valueOf(this.red));
                    continue block6;
                }
                case NORMAL: {
                    this.putElement(e, this.normal.x, this.normal.y, this.normal.z);
                    continue block6;
                }
                case UV: {
                    this.putElement(e, u, v);
                    continue block6;
                }
            }
            this.putElement(e, new Number[0]);
        }
    }

    protected void putElement(VertexFormatElement e, Number ... ns) {
        block9: for (int i = 0; i < e.func_177370_d(); ++i) {
            Number n = i < ns.length ? (Number)ns[i] : (Number)0;
            switch (e.func_177367_b()) {
                case BYTE: {
                    this.buf.put((byte)(n.floatValue() * 127.0f));
                    continue block9;
                }
                case UBYTE: {
                    this.buf.put((byte)(n.floatValue() * 255.0f));
                    continue block9;
                }
                case SHORT: {
                    this.buf.putShort((short)(n.floatValue() * 32767.0f));
                    continue block9;
                }
                case USHORT: {
                    this.buf.putShort((short)(n.floatValue() * 65535.0f));
                    continue block9;
                }
                case INT: {
                    this.buf.putInt((int)(n.doubleValue() * 2.147483647E9));
                    continue block9;
                }
                case UINT: {
                    this.buf.putInt((int)(n.doubleValue() * -1.0));
                    continue block9;
                }
                case FLOAT: {
                    this.buf.putFloat(n.floatValue());
                }
            }
        }
    }

    static {
        theFormat.func_181721_a(DefaultVertexFormats.field_181713_m);
        theFormat.func_181721_a(DefaultVertexFormats.field_181714_n);
        theFormat.func_181721_a(DefaultVertexFormats.field_181715_o);
        theFormat.func_181721_a(DefaultVertexFormats.field_181718_r);
        theFormat.func_181721_a(DefaultVertexFormats.field_181717_q);
        emptyQuads = new ArrayList<BakedQuad>();
        faceQuads = new HashMap<EnumFacing, List<BakedQuad>>();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            faceQuads.put(face, emptyQuads);
        }
        transThirdPerson = new ItemTransformVec3f(new Vector3f(75.0f, -45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f));
        transFirstPerson = new ItemTransformVec3f(new Vector3f(0.0f, -45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f));
        transOnHead = new ItemTransformVec3f(new Vector3f(0.0f, 180.0f, 0.0f), new Vector3f(0.0f, 0.8125f, 0.4375f), new Vector3f(1.0f, 1.0f, 1.0f));
        transInGui = new ItemTransformVec3f(new Vector3f(30.0f, -45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f));
        transOnGround = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f));
        transFixed = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f));
        transforms = new ItemCameraTransforms(transThirdPerson, transThirdPerson, transFirstPerson, transFirstPerson, transOnHead, transInGui, transOnGround, transFixed);
    }
}

