/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders.util;

import bedrockbreaker.graduatedcylinders.util.FluidHelper;
import bedrockbreaker.graduatedcylinders.util.MathHelper;
import bedrockbreaker.graduatedcylinders.util.Matrix4d;
import bedrockbreaker.graduatedcylinders.util.Vec3d;
import java.awt.Rectangle;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="graduatedcylinders", value={Side.CLIENT})
public class Scene3DRenderer {
    private Minecraft mc = Minecraft.func_71410_x();
    private World world;
    private BlockPos blockOrigin;
    private ArrayList<BlockPos> neighbors;
    private boolean isDragging;
    private boolean renderNeighbors;
    private long initTime;
    private Vec3d origin;
    private double pitch;
    private double yaw;
    private double distance;
    private Vec3d cameraPosition;
    private Matrix4d pitchRotation;
    private Matrix4d yawRotation;
    private Matrix4d viewMatrix;
    private Matrix4d transposeViewMatrix;
    private Matrix4d inverseViewMatrix;
    private Matrix4d projectionMatrix;
    private Matrix4d transposeProjectionMatrix;
    private Matrix4d inverseProjectionMatrix;
    private Rectangle viewport;
    public EnumFacing hoveredFace;
    public EnumFacing selectedFace;
    public ArrayList<FluidHelper.TransferrableFluidResult> allowedFaces;
    private static final FloatBuffer MATRIX_BUFFER = GLAllocation.func_74529_h((int)16);
    private static TextureAtlasSprite hoveredFaceSprite;
    private static TextureAtlasSprite selectedFaceSprite;
    private static TextureAtlasSprite blockedFaceSprite;

    public Scene3DRenderer(BlockPos blockOrigin, ArrayList<FluidHelper.TransferrableFluidResult> allowedFaces) {
        this.world = this.mc.field_71439_g.field_70170_p;
        this.neighbors = new ArrayList();
        this.isDragging = false;
        this.renderNeighbors = true;
        this.initTime = 0L;
        this.origin = new Vec3d();
        this.pitch = 0.0;
        this.yaw = 0.0;
        this.distance = 5.0;
        this.cameraPosition = new Vec3d();
        this.pitchRotation = new Matrix4d();
        this.yawRotation = new Matrix4d();
        this.world = this.mc.field_71439_g.field_70170_p;
        this.blockOrigin = blockOrigin;
        this.allowedFaces = allowedFaces;
        for (EnumFacing face : EnumFacing.values()) {
            this.neighbors.add(blockOrigin.func_177972_a(face));
        }
        this.origin.set(blockOrigin).add(0.5);
        this.pitch = -this.mc.field_71439_g.field_70125_A;
        this.yaw = 180.0f - this.mc.field_71439_g.field_70177_z;
        this.pitchRotation.setIdentity();
        this.yawRotation.setIdentity();
    }

    @SubscribeEvent
    public static void registerSprites(TextureStitchEvent.Pre event) {
        hoveredFaceSprite = event.getMap().func_174942_a(new ResourceLocation("graduatedcylinders", "overlay/hovered_face"));
        selectedFaceSprite = event.getMap().func_174942_a(new ResourceLocation("graduatedcylinders", "overlay/selected_face"));
        blockedFaceSprite = event.getMap().func_174942_a(new ResourceLocation("graduatedcylinders", "overlay/blocked_face"));
    }

    public void init() {
        this.initTime = System.currentTimeMillis();
    }

    public void drawScreen(float partialTick, Rectangle viewport) {
        if (!this.updateCamera(partialTick, viewport)) {
            return;
        }
        this.applyCamera(partialTick);
        this.renderScene(partialTick);
        this.renderOverlays();
        this.cleanUpGlState();
    }

    public void handleMouseinput() {
        if (Mouse.getEventButton() == 0) {
            this.isDragging = Mouse.getEventButtonState();
        }
        if (this.isDragging) {
            double dx = (double)Mouse.getEventDX() / (double)this.mc.field_71443_c;
            double dy = (double)Mouse.getEventDY() / (double)this.mc.field_71440_d;
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)42)) {
                this.distance = MathHelper.clamp(this.distance - dy * 15.0, 0.01, 200.0);
            } else {
                this.yaw -= 4.0 * dx * 180.0;
                this.pitch = MathHelper.clamp(this.pitch + 2.0 * dy * 180.0, -80.0, 80.0);
            }
        }
        if (this.viewMatrix != null && this.projectionMatrix != null && this.viewport != null) {
            if (this.inverseProjectionMatrix == null) {
                this.inverseProjectionMatrix = new Matrix4d(this.projectionMatrix).invert();
            }
            if (this.inverseViewMatrix == null) {
                this.inverseViewMatrix = new Matrix4d(this.viewMatrix).invert();
            }
            Matrix4d inverseMatrix = Matrix4d.multiply(this.inverseViewMatrix, this.inverseProjectionMatrix);
            double clipX = ((double)Mouse.getEventX() - this.viewport.getX()) / this.viewport.getWidth() * 2.0 - 1.0;
            double clipY = ((double)Mouse.getEventY() - this.viewport.getY()) / this.viewport.getHeight() * 2.0 - 1.0;
            double nearW = clipX * inverseMatrix.m30 + clipY * inverseMatrix.m31 - inverseMatrix.m32 + inverseMatrix.m33;
            Vec3d nearXYZ = new Vec3d(clipX * inverseMatrix.m00 + clipY * inverseMatrix.m01 - inverseMatrix.m02 + inverseMatrix.m03, clipX * inverseMatrix.m10 + clipY * inverseMatrix.m11 - inverseMatrix.m12 + inverseMatrix.m13, clipX * inverseMatrix.m20 + clipY * inverseMatrix.m21 - inverseMatrix.m22 + inverseMatrix.m23).scale(1.0 / nearW);
            double farW = clipX * inverseMatrix.m30 + clipY * inverseMatrix.m31 + inverseMatrix.m32 + inverseMatrix.m33;
            Vec3d farXYZ = new Vec3d(clipX * inverseMatrix.m00 + clipY * inverseMatrix.m01 + inverseMatrix.m02 + inverseMatrix.m03, clipX * inverseMatrix.m10 + clipY * inverseMatrix.m11 + inverseMatrix.m12 + inverseMatrix.m13, clipX * inverseMatrix.m20 + clipY * inverseMatrix.m21 + inverseMatrix.m22 + inverseMatrix.m23).scale(1.0 / farW);
            Vec3d start = this.inverseViewMatrix.getTranslationVector();
            Vec3d end = new Vec3d(farXYZ).sub(nearXYZ).normalize().scale(this.distance * 2.0).add(start);
            this.updateHoveredFace(start, end);
        }
        long timeSinceInit = System.currentTimeMillis() - this.initTime;
        if (Mouse.getEventButton() == -1 || Mouse.getEventButtonState() || timeSinceInit < 500L || this.viewMatrix == null || this.projectionMatrix == null || this.viewport == null) {
            return;
        }
        if (Mouse.getEventButton() == 1) {
            if (this.hoveredFace != null && this.allowedFaces.get(this.hoveredFace.func_176745_a()).canTransfer()) {
                this.selectedFace = this.hoveredFace;
            }
        } else if (Mouse.getEventButton() == 2) {
            this.renderNeighbors = !this.renderNeighbors;
        }
    }

    public EnumFacing getHoveredFace() {
        return this.hoveredFace;
    }

    private void updateHoveredFace(Vec3d start, Vec3d end) {
        this.hoveredFace = null;
        if (this.world.func_175623_d(this.blockOrigin)) {
            return;
        }
        start.add(this.origin);
        end.add(this.origin);
        IBlockState blockState = this.world.func_180495_p(this.blockOrigin);
        RayTraceResult hit = blockState.func_185910_a(this.world, this.blockOrigin, new net.minecraft.util.math.Vec3d(start.x, start.y, start.z), new net.minecraft.util.math.Vec3d(end.x, end.y, end.z));
        if (hit == null || hit.field_72313_a == RayTraceResult.Type.MISS) {
            return;
        }
        this.hoveredFace = hit.field_178784_b;
    }

    private boolean updateCamera(float partialTick, Rectangle viewport) {
        if (viewport.width <= 0 || viewport.height <= 0) {
            return false;
        }
        this.viewport = viewport;
        if (this.projectionMatrix == null) {
            this.projectionMatrix = new Matrix4d();
        }
        this.projectionMatrix.set(new double[]{3.7320508075688776 * (double)viewport.height / (double)viewport.width, 0.0, 0.0, 0.0, 0.0, 3.7320508075688776, 0.0, 0.0, 0.0, 0.0, -1.002002002002002, -0.10010010010010009, 0.0, 0.0, -1.0, 0.0});
        this.transposeProjectionMatrix = new Matrix4d(this.projectionMatrix).transpose();
        this.inverseProjectionMatrix = null;
        this.cameraPosition = new Vec3d(0.0, 0.0, this.distance);
        this.pitchRotation.setToRotationX(Math.toRadians(this.pitch)).transform(this.cameraPosition);
        this.yawRotation.setToRotationY(Math.toRadians(this.yaw)).transform(this.cameraPosition);
        Vec3d forward = new Vec3d().sub(this.cameraPosition).normalize();
        Vec3d left = Vec3d.cross(forward, new Vec3d(0.0, 1.0, 0.0)).normalize();
        Vec3d up = Vec3d.cross(left, forward).normalize();
        if (this.viewMatrix == null) {
            this.viewMatrix = new Matrix4d();
        }
        this.viewMatrix.set(new double[]{left.x, left.y, left.z, 0.0, up.x, up.y, up.z, 0.0, -forward.x, -forward.y, -forward.z, 0.0, 0.0, 0.0, 0.0, 1.0});
        Vec3d cameraPosTemp = new Vec3d(this.cameraPosition);
        this.viewMatrix.transformNormal(cameraPosTemp.scale(-1.0));
        this.viewMatrix.setTranslation(cameraPosTemp);
        this.transposeViewMatrix = new Matrix4d(this.viewMatrix).transpose();
        this.inverseViewMatrix = null;
        return true;
    }

    private void applyCamera(float partialTick) {
        GL11.glViewport((int)this.viewport.x, (int)this.viewport.y, (int)this.viewport.width, (int)this.viewport.height);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GlStateManager.func_179094_E();
        if (this.transposeProjectionMatrix != null) {
            this.loadMatrix(this.transposeProjectionMatrix);
        }
        GL11.glMatrixMode((int)5888);
        GlStateManager.func_179094_E();
        if (this.transposeViewMatrix != null) {
            this.loadMatrix(this.transposeViewMatrix);
        }
        GL11.glTranslatef((float)((float)(-this.cameraPosition.x)), (float)((float)(-this.cameraPosition.y)), (float)((float)(-this.cameraPosition.z)));
    }

    private void loadMatrix(Matrix4d matrix) {
        MATRIX_BUFFER.rewind();
        MATRIX_BUFFER.put((float)matrix.m00);
        MATRIX_BUFFER.put((float)matrix.m01);
        MATRIX_BUFFER.put((float)matrix.m02);
        MATRIX_BUFFER.put((float)matrix.m03);
        MATRIX_BUFFER.put((float)matrix.m10);
        MATRIX_BUFFER.put((float)matrix.m11);
        MATRIX_BUFFER.put((float)matrix.m12);
        MATRIX_BUFFER.put((float)matrix.m13);
        MATRIX_BUFFER.put((float)matrix.m20);
        MATRIX_BUFFER.put((float)matrix.m21);
        MATRIX_BUFFER.put((float)matrix.m22);
        MATRIX_BUFFER.put((float)matrix.m23);
        MATRIX_BUFFER.put((float)matrix.m30);
        MATRIX_BUFFER.put((float)matrix.m31);
        MATRIX_BUFFER.put((float)matrix.m32);
        MATRIX_BUFFER.put((float)matrix.m33);
        MATRIX_BUFFER.rewind();
        GL11.glLoadMatrix((FloatBuffer)MATRIX_BUFFER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderScene(float partialTick) {
        GlStateManager.func_179089_o();
        GlStateManager.func_179091_B();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        this.mc.field_71460_t.func_175072_h();
        this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        Vec3d translation = new Vec3d(this.cameraPosition).sub(this.origin);
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        try {
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                this.setGlStateForPass(layer, false);
                this.doWorldRenderPass(translation, this.blockOrigin, layer);
            }
            if (this.renderNeighbors) {
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                    this.setGlStateForPass(layer, true);
                    this.doWorldRenderPass(translation, this.neighbors, layer);
                }
            }
        }
        finally {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        }
        RenderHelper.func_74519_b();
        TileEntityRendererDispatcher.field_147556_a.field_147560_j = this.origin.x - this.cameraPosition.x;
        TileEntityRendererDispatcher.field_147556_a.field_147561_k = this.origin.y - this.cameraPosition.y;
        TileEntityRendererDispatcher.field_147556_a.field_147558_l = this.origin.z - this.cameraPosition.z;
        TileEntityRendererDispatcher.field_147554_b = this.origin.x - this.cameraPosition.x;
        TileEntityRendererDispatcher.field_147555_c = this.origin.y - this.cameraPosition.y;
        TileEntityRendererDispatcher.field_147552_d = this.origin.z - this.cameraPosition.z;
        for (int pass = 0; pass < 2; ++pass) {
            ForgeHooksClient.setRenderPass((int)pass);
            this.setGlStateForPass(pass, false);
            this.doTileEntityRenderPass(this.blockOrigin, pass, partialTick);
            if (!this.renderNeighbors) continue;
            this.setGlStateForPass(pass, true);
            this.doTileEntityRenderPass(this.neighbors, pass, partialTick);
        }
        ForgeHooksClient.setRenderPass((int)-1);
        this.setGlStateForPass(0, false);
    }

    private void setGlStateForPass(BlockRenderLayer layer, boolean isNeighbor) {
        this.setGlStateForPass(layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0, isNeighbor);
    }

    private void setGlStateForPass(int layer, boolean isNeighbor) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isNeighbor) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)32769);
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
        if (layer == 0) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179132_a((boolean)false);
        }
    }

    private void doWorldRenderPass(Vec3d translation, ArrayList<BlockPos> blocks, BlockRenderLayer layer) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        buffer.func_178969_c(translation.x, translation.y, translation.z);
        for (BlockPos pos : blocks) {
            IBlockState blockState = this.world.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (!block.canRenderInLayer(blockState = blockState.func_185899_b((IBlockAccess)this.world, pos), layer)) continue;
            this.renderBlock(blockState, pos, (IBlockAccess)this.world, buffer);
        }
        Tessellator.func_178181_a().func_78381_a();
        buffer.func_178969_c(0.0, 0.0, 0.0);
    }

    private void doWorldRenderPass(Vec3d translation, BlockPos blockPos, BlockRenderLayer layer) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        list.add(blockPos);
        this.doWorldRenderPass(translation, list, layer);
    }

    private void renderBlock(IBlockState blockState, BlockPos blockPos, IBlockAccess blockAccess, BufferBuilder buffer) {
        try {
            BlockRendererDispatcher blockRendererDispatcher = this.mc.func_175602_ab();
            EnumBlockRenderType blockRenderType = blockState.func_185901_i();
            if (blockRenderType != EnumBlockRenderType.MODEL) {
                blockRendererDispatcher.func_175018_a(blockState, blockPos, blockAccess, buffer);
                return;
            }
            IBakedModel model = blockRendererDispatcher.func_184389_a(blockState);
            blockState = blockState.func_177230_c().getExtendedState(blockState, blockAccess, blockPos);
            blockRendererDispatcher.func_175019_b().func_178267_a(blockAccess, model, blockState, blockPos, buffer, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void doTileEntityRenderPass(ArrayList<BlockPos> blocks, int pass, float partialTick) {
        for (BlockPos pos : blocks) {
            TileEntity tileEntity = this.world.func_175625_s(pos);
            if (tileEntity == null) continue;
            Vec3d renderPos = new Vec3d(this.cameraPosition).add(pos).sub(this.origin);
            if (tileEntity.getClass() == TileEntityChest.class) {
                TileEntityChest chest = (TileEntityChest)tileEntity;
                if (chest.field_145991_k != null) {
                    tileEntity = chest.field_145991_k;
                    renderPos.x -= 1.0;
                } else if (chest.field_145992_i != null) {
                    tileEntity = chest.field_145992_i;
                    renderPos.z -= 1.0;
                }
            }
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(tileEntity, renderPos.x, renderPos.y, renderPos.z, partialTick);
        }
    }

    private void doTileEntityRenderPass(BlockPos blockPos, int pass, float partialTick) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        list.add(blockPos);
        this.doTileEntityRenderPass(list, pass, partialTick);
    }

    private void renderOverlays() {
        if (this.selectedFace == null) {
            return;
        }
        GlStateManager.func_179097_i();
        RenderHelper.func_74518_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        Vec3d translation = new Vec3d(this.cameraPosition).sub(this.origin);
        buffer.func_178969_c(translation.x, translation.y, translation.z);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.drawOverlay(buffer, this.blockOrigin, this.selectedFace, selectedFaceSprite, true);
        if (this.hoveredFace != null) {
            this.drawOverlay(buffer, this.blockOrigin, this.hoveredFace, this.allowedFaces.get(this.hoveredFace.func_176745_a()).canTransfer() ? hoveredFaceSprite : blockedFaceSprite, false);
        }
        Tessellator.func_178181_a().func_78381_a();
        buffer.func_178969_c(0.0, 0.0, 0.0);
    }

    private void drawOverlay(BufferBuilder buffer, BlockPos blockPos, EnumFacing face, TextureAtlasSprite overlay, boolean drawInverse) {
        int i;
        double[] texelData = this.getPositionsAndUVForFace(blockPos, face, overlay.func_94209_e(), overlay.func_94212_f(), overlay.func_94206_g(), overlay.func_94210_h());
        for (i = 0; i < 4; ++i) {
            buffer.func_181662_b(texelData[i * 5], texelData[i * 5 + 1], texelData[i * 5 + 2]).func_187315_a(texelData[i * 5 + 3], texelData[i * 5 + 4]).func_181675_d();
        }
        if (drawInverse) {
            for (i = 3; i >= 0; --i) {
                buffer.func_181662_b(texelData[i * 5], texelData[i * 5 + 1], texelData[i * 5 + 2]).func_187315_a(texelData[i * 5 + 3], texelData[i * 5 + 4]).func_181675_d();
            }
        }
    }

    private double[] getPositionsAndUVForFace(BlockPos pos, EnumFacing face, float minU, float maxU, float minV, float maxV) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (face) {
            case NORTH: {
                return new double[]{x + 1, y, z, minU, minV, x, y, z, maxU, minV, x, y + 1, z, maxU, maxV, x + 1, y + 1, z, minU, maxV};
            }
            case SOUTH: {
                return new double[]{x, y, z + 1, maxU, minV, x + 1, y, z + 1, minU, minV, x + 1, y + 1, z + 1, minU, maxV, x, y + 1, z + 1, maxU, maxV};
            }
            case EAST: {
                return new double[]{x + 1, y + 1, z, maxU, maxV, x + 1, y + 1, z + 1, minU, maxV, x + 1, y, z + 1, minU, minV, x + 1, y, z, maxU, minV};
            }
            case WEST: {
                return new double[]{x, y, z, maxU, minV, x, y, z + 1, minU, minV, x, y + 1, z + 1, minU, maxV, x, y + 1, z, maxU, maxV};
            }
            case UP: {
                return new double[]{x + 1, y + 1, z + 1, minU, minV, x + 1, y + 1, z, minU, maxV, x, y + 1, z, maxU, maxV, x, y + 1, z + 1, maxU, minV};
            }
            case DOWN: {
                return new double[]{x, y, z, maxU, maxV, x + 1, y, z, minU, maxV, x + 1, y, z + 1, minU, minV, x, y, z + 1, maxU, minV};
            }
        }
        return null;
    }

    private void cleanUpGlState() {
        RenderHelper.func_74519_b();
        GL11.glViewport((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GlStateManager.func_179121_F();
        GL11.glMatrixMode((int)5888);
        GlStateManager.func_179121_F();
    }
}

