/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders.util;

import java.util.HashMap;

public enum Operator {
    GROUP('(', 0),
    UNGROUP(')', 7),
    PERCENT('%', 6, a -> a, true),
    TRILLION('t', 6, a -> a * 1.0E12, true),
    GIGA('g', 6, a -> a * 1.0E9, true),
    BILLION('b', 6, a -> a * 1.0E9, true),
    MILLION('m', 6, a -> a * 1000000.0, true),
    THOUSAND('k', 6, a -> a * 1000.0, true),
    MAGNITUDE('e', 5, (a, b) -> a * Math.pow(10.0, b), false),
    POWER('^', 4, (a, b) -> Math.pow(a, b), false),
    NEGATE('~', 3, a -> -a, false),
    IDENTITY('#', 3, a -> a, false),
    MULTIPLY('*', 2, (a, b) -> a * b, true),
    DIVIDE('/', 2, (a, b) -> a / b, true),
    SUBTRACT('-', 1, (a, b) -> a - b, true),
    ADD('+', 1, (a, b) -> a + b, true);

    private static final HashMap<Character, Operator> OPERATORS;
    public final int priority;
    private final char operator;
    private final BinaryOperator binary;
    private final UnaryOperator unary;
    private final boolean isLeftAssociative;

    public static boolean isOperator(char c) {
        return OPERATORS.containsKey(Character.valueOf(c));
    }

    public static Operator getOperator(char c) {
        return OPERATORS.get(Character.valueOf(c));
    }

    private Operator(char operator, int priority, BinaryOperator executor, boolean isLeftAssociative) {
        this.operator = operator;
        this.priority = priority;
        this.binary = executor;
        this.unary = null;
        this.isLeftAssociative = isLeftAssociative;
    }

    private Operator(char operator, int priority, UnaryOperator modifier, boolean isLeftAssociative) {
        this.operator = operator;
        this.priority = priority;
        this.binary = null;
        this.unary = modifier;
        this.isLeftAssociative = isLeftAssociative;
    }

    private Operator(char operator, int priority) {
        this.operator = operator;
        this.priority = priority;
        this.binary = null;
        this.unary = null;
        this.isLeftAssociative = false;
    }

    public char getChar() {
        return this.operator;
    }

    public double execute(double left, double right) {
        return this.binary.execute(left, right);
    }

    public double execute(double value) {
        return this.unary.execute(value);
    }

    public boolean isUnary() {
        return this.unary != null;
    }

    public boolean isLeftAssociative() {
        return this.isLeftAssociative;
    }

    public boolean isPrefix() {
        return this.isUnary() && !this.isLeftAssociative();
    }

    public boolean isPostfix() {
        return this.isUnary() && this.isLeftAssociative();
    }

    static {
        OPERATORS = new HashMap();
        for (Operator operator : Operator.values()) {
            OPERATORS.put(Character.valueOf(operator.getChar()), operator);
        }
    }

    @FunctionalInterface
    private static interface UnaryOperator {
        public double execute(double var1);
    }

    @FunctionalInterface
    private static interface BinaryOperator {
        public double execute(double var1, double var3);
    }
}

