/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders.util;

import bedrockbreaker.graduatedcylinders.api.IProxyFluidStack;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="graduatedcylinders", value={Side.CLIENT})
public class ColorCache {
    public static final HashMap<String, String> fluidColorCodeCache = new HashMap();
    private static final float[][] colors = new float[][]{{60.558163f, -63.606228f, 61.388107f}, {63.051556f, -35.491528f, -10.42863f}, {35.100998f, 59.10787f, 49.40268f}, {40.328693f, 72.49666f, -44.889473f}, {76.078354f, 21.322464f, 79.700356f}, {69.61017f, -0.0024711133f, 4.5678997E-4f}, {36.14585f, -0.0015051753f, 2.7823448E-4f}, {46.506615f, 51.0979f, -84.20022f}, {88.97106f, -74.232376f, 65.933334f}, {91.98227f, -42.449444f, -12.740982f}, {60.265858f, 64.20675f, 36.54832f}, {65.734146f, 82.576416f, -52.2104f}, {97.40514f, -19.41877f, 77.31046f}, {100.0f, -0.0033483072f, 6.189409E-4f}};

    public static String getFluidColorCode(IProxyFluidStack fluidStack, int baseColor) {
        Object texels;
        Object object;
        String registryName = fluidStack.getUnlocalizedName();
        if (fluidColorCodeCache.containsKey(registryName)) {
            return fluidColorCodeCache.get(registryName);
        }
        float totalL = 0.0f;
        float totalA = 0.0f;
        float totalB = 0.0f;
        int totalTexels = 0;
        TextureAtlasSprite fluidSprite = fluidStack.getSprite();
        if (fluidSprite == null || fluidSprite.func_110970_k() == 0) {
            int[][] nArrayArray = new int[1][];
            object = nArrayArray;
            nArrayArray[0] = new int[]{-1};
        } else {
            object = fluidSprite.func_147965_a(0);
        }
        Object object2 = texels = object;
        int n = ((int[][])object2).length;
        for (int i = 0; i < n; ++i) {
            int[] row;
            for (int argb : row = object2[i]) {
                if ((argb & 0xFF000000) >>> 24 < 16) continue;
                float r = (float)((argb >> 16 & 0xFF) * (baseColor >> 16 & 0xFF)) / 65025.0f;
                float g = (float)((argb >> 8 & 0xFF) * (baseColor >> 8 & 0xFF)) / 65025.0f;
                float b = (float)((argb & 0xFF) * (baseColor & 0xFF)) / 65025.0f;
                r = (double)r <= 0.04045 ? r / 12.92f : (float)Math.pow(((double)r + 0.055) / 1.055, 2.4);
                g = (double)g <= 0.04045 ? g / 12.92f : (float)Math.pow(((double)g + 0.055) / 1.055, 2.4);
                b = (double)b <= 0.04045 ? b / 12.92f : (float)Math.pow(((double)b + 0.055) / 1.055, 2.4);
                float x = 0.4124564f * r + 0.3575761f * g + 0.1804375f * b;
                float y = 0.2126729f * r + 0.7151522f * g + 0.072175f * b;
                float z = 0.0193339f * r + 0.119192f * g + 0.9503041f * b;
                float xr = x / 0.950489f;
                float yr = y;
                float zr = z / 1.08884f;
                float fx = xr > 0.008856452f ? (float)Math.pow(xr, 0.3333333333333333) : xr * 841.0f / 108.0f + 0.13793103f;
                float fy = yr > 0.008856452f ? (float)Math.pow(yr, 0.3333333333333333) : yr * 841.0f / 108.0f + 0.13793103f;
                float fz = zr > 0.008856452f ? (float)Math.pow(zr, 0.3333333333333333) : zr * 841.0f / 108.0f + 0.13793103f;
                totalL += 116.0f * fy - 16.0f;
                totalA += 500.0f * (fx - fy);
                totalB += 200.0f * (fy - fz);
                ++totalTexels;
            }
        }
        if (totalTexels == 0) {
            fluidColorCodeCache.put(registryName, TextFormatting.WHITE.toString());
            return fluidColorCodeCache.get(registryName);
        }
        float avgL = totalL / (float)totalTexels;
        float avgA = totalA / (float)totalTexels;
        float avgB = totalB / (float)totalTexels;
        float minDistance = 2.1474836E9f;
        int chosenColorIndex = 13;
        for (int i = 0; i < colors.length; ++i) {
            float[] color = colors[i];
            float distanceSquared = (color[0] - avgL) * (color[0] - avgL) + (color[1] - avgA) * (color[1] - avgA) + (color[2] - avgB) * (color[2] - avgB);
            if (distanceSquared >= minDistance) continue;
            minDistance = distanceSquared;
            chosenColorIndex = i;
        }
        fluidColorCodeCache.put(registryName, "\u00a7" + Integer.toHexString(chosenColorIndex + 2));
        return fluidColorCodeCache.get(registryName);
    }

    @SubscribeEvent
    public static void onResourceReload(TextureStitchEvent.Pre event) {
        fluidColorCodeCache.clear();
    }
}

