/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders.proxy.mode;

import bedrockbreaker.graduatedcylinders.api.IHandlerMode;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class IngotMode
implements IHandlerMode {
    public static final IngotMode INSTANCE = new IngotMode();
    public ItemStack icon = new ItemStack(Items.field_151042_j);

    @Override
    public int[] getDeltas(int amount, int heldCapacity, int tankCapacity) {
        int maxCapacity = Math.min(heldCapacity, tankCapacity);
        return new int[]{1, 16, 72, 144, 1296, 9216, maxCapacity - maxCapacity % 144};
    }

    @Override
    public ArrayList<String> getStringDeltas() {
        ArrayList<String> keys = new ArrayList<String>(7);
        keys.add(I18n.func_135052_a((String)"gc.gui.1mb", (Object[])new Object[0]));
        keys.add(I18n.func_135052_a((String)"gc.gui.16mb", (Object[])new Object[0]));
        keys.add(I18n.func_135052_a((String)"gc.gui.72mb", (Object[])new Object[0]));
        keys.add(I18n.func_135052_a((String)"gc.gui.144mb", (Object[])new Object[0]));
        keys.add(I18n.func_135052_a((String)"gc.gui.1296mb", (Object[])new Object[0]));
        keys.add(I18n.func_135052_a((String)"gc.gui.9216mb", (Object[])new Object[0]));
        keys.add(I18n.func_135052_a((String)"gc.gui.allmb", (Object[])new Object[0]));
        return keys;
    }

    @Override
    public String formatAmount(int amountIn, boolean useLongName) {
        int nuggets;
        float ingots = (float)(amountIn / 144) + (amountIn % 144 > 0 && amountIn % 72 == 0 ? 0.5f : 0.0f);
        amountIn = (int)((float)amountIn - ingots * 144.0f);
        if ((ingots > 0.0f ? 1 : 0) + ((nuggets = amountIn / 16) > 0 ? 1 : 0) + ((amountIn -= nuggets * 16) > 0 ? 1 : 0) > 1) {
            ArrayList<String> units = new ArrayList<String>(3);
            if (ingots > 0.0f) {
                units.add(I18n.func_135052_a((String)"gc.gui.ingot.short", (Object[])new Object[]{String.format("%.1f", Float.valueOf(ingots)).replaceFirst("[.,]0$", "")}));
            }
            if (nuggets > 0) {
                units.add(I18n.func_135052_a((String)"gc.gui.nugget.short", (Object[])new Object[]{nuggets}));
            }
            if (amountIn > 0) {
                units.add(I18n.func_135052_a((String)"gc.gui.mb", (Object[])new Object[]{amountIn}));
            }
            return String.join((CharSequence)", ", units);
        }
        if (ingots > 0.0f) {
            return I18n.func_135052_a((String)"gc.gui.ingot", (Object[])new Object[]{String.format("%.1f", Float.valueOf(ingots)).replaceFirst("[.,]0$", "")});
        }
        if (nuggets > 0) {
            return I18n.func_135052_a((String)"gc.gui.nugget", (Object[])new Object[]{nuggets});
        }
        if (amountIn > 0) {
            return I18n.func_135052_a((String)"gc.gui.mb", (Object[])new Object[]{amountIn});
        }
        return I18n.func_135052_a((String)"gc.gui.ingot", (Object[])new Object[]{"0"});
    }

    @Override
    public ItemStack getModeIcon() {
        return this.icon;
    }

    @Override
    public String getModeName() {
        return I18n.func_135052_a((String)"gc.gui.ingotmode", (Object[])new Object[0]);
    }
}

