/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders.proxy.handler;

import bedrockbreaker.graduatedcylinders.api.IProxyFluidHandler;
import bedrockbreaker.graduatedcylinders.api.IProxyFluidStack;
import bedrockbreaker.graduatedcylinders.api.IProxyTankProperties;
import bedrockbreaker.graduatedcylinders.proxy.stack.GasStackGC;
import bedrockbreaker.graduatedcylinders.proxy.tankproperties.GasTankProperties;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class GasHandler
implements IProxyFluidHandler {
    protected IGasHandler gasHandler;
    protected EnumFacing side;

    public GasHandler(IGasHandler gasHandler, EnumFacing side) {
        this.gasHandler = gasHandler;
        this.side = side;
    }

    @Override
    public GasStackGC loadFluidStackFromNBT(NBTTagCompound nbt) {
        GasStack gasStack = GasStack.readFromNBT((NBTTagCompound)nbt);
        return gasStack == null ? null : new GasStackGC(gasStack);
    }

    @Override
    public IProxyTankProperties getTankProperties(int tankIndex) {
        return new GasTankProperties(this.gasHandler.getTankInfo()[tankIndex]);
    }

    @Override
    public int getNumTanks() {
        return this.gasHandler.getTankInfo().length;
    }

    @Override
    public int fill(IProxyFluidStack resource, boolean doFill) {
        if (!(resource instanceof GasStackGC)) {
            return 0;
        }
        return this.gasHandler.receiveGas(this.side, ((GasStackGC)resource).gasStack, doFill);
    }

    @Override
    @Nullable
    public GasStackGC drain(int maxAmount, boolean doDrain) {
        GasStack removedGas = this.gasHandler.drawGas(this.side, maxAmount, doDrain);
        return removedGas == null ? null : new GasStackGC(removedGas);
    }

    @Override
    @Nullable
    public GasStackGC drain(IProxyFluidStack resource, boolean doDrain) {
        if (!(resource instanceof GasStackGC)) {
            return null;
        }
        GasStack removedGas = this.gasHandler.drawGas(this.side, resource.getAmount(), doDrain);
        return removedGas == null ? null : new GasStackGC(removedGas);
    }
}

