/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders.proxy.handler;

import bedrockbreaker.graduatedcylinders.api.IProxyFluidHandler;
import bedrockbreaker.graduatedcylinders.api.IProxyFluidStack;
import bedrockbreaker.graduatedcylinders.api.IProxyTankProperties;
import bedrockbreaker.graduatedcylinders.proxy.stack.FluidStackGC;
import bedrockbreaker.graduatedcylinders.proxy.tankproperties.FluidTankProperties;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidHandler
implements IProxyFluidHandler {
    protected IFluidHandler fluidHandler;

    public FluidHandler(IFluidHandler fluidHandler) {
        this.fluidHandler = fluidHandler;
    }

    @Override
    public FluidStackGC loadFluidStackFromNBT(NBTTagCompound nbt) {
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        return fluidStack == null ? null : new FluidStackGC(fluidStack);
    }

    @Override
    public IProxyTankProperties getTankProperties(int tankIndex) {
        return new FluidTankProperties(this.fluidHandler.getTankProperties()[tankIndex]);
    }

    @Override
    public int getNumTanks() {
        return this.fluidHandler.getTankProperties().length;
    }

    @Override
    public int fill(IProxyFluidStack resource, boolean doFill) {
        if (!(resource instanceof FluidStackGC)) {
            return 0;
        }
        return this.fluidHandler.fill(((FluidStackGC)resource).fluidStack, doFill);
    }

    @Override
    @Nullable
    public FluidStackGC drain(int maxAmount, boolean doDrain) {
        FluidStack removedFluid = this.fluidHandler.drain(maxAmount, doDrain);
        return removedFluid == null ? null : new FluidStackGC(removedFluid);
    }

    @Override
    @Nullable
    public FluidStackGC drain(IProxyFluidStack resource, boolean doDrain) {
        if (!(resource instanceof FluidStackGC)) {
            return null;
        }
        FluidStack removedFluid = this.fluidHandler.drain(((FluidStackGC)resource).fluidStack, doDrain);
        return removedFluid == null ? null : new FluidStackGC(removedFluid);
    }
}

