/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders.network;

import bedrockbreaker.graduatedcylinders.api.IProxyFluidHandlerItem;
import bedrockbreaker.graduatedcylinders.api.IProxyFluidStack;
import bedrockbreaker.graduatedcylinders.util.FluidHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketContainerTransferFluid
implements IMessage {
    private int slot;

    public PacketContainerTransferFluid() {
    }

    public PacketContainerTransferFluid(int slot) {
        this.slot = slot;
    }

    public void fromBytes(ByteBuf buffer) {
        try {
            this.slot = buffer.readInt();
        }
        catch (IndexOutOfBoundsException error) {
            System.out.println(error);
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.slot);
    }

    public static class Handler
    implements IMessageHandler<PacketContainerTransferFluid, IMessage> {
        public IMessage onMessage(PacketContainerTransferFluid message, MessageContext ctx) {
            if (ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                IProxyFluidHandlerItem underFluidHandler;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                Container container = player.field_71070_bA;
                Slot hoveredSlot = (Slot)container.field_75151_b.get(message.slot);
                IProxyFluidHandlerItem heldFluidHandler = FluidHelper.getProxyFluidHandler(player.field_71071_by.func_70445_o());
                int transferAmount = FluidHelper.getTransferAmount(heldFluidHandler, underFluidHandler = FluidHelper.getProxyFluidHandler(hoveredSlot.func_75211_c()));
                if (transferAmount == 0) {
                    return;
                }
                IProxyFluidStack fluidStack = heldFluidHandler.getTankProperties(0).getContents();
                if (fluidStack == null) {
                    fluidStack = underFluidHandler.getTankProperties(0).getContents();
                }
                if (fluidStack == null) {
                    return;
                }
                if (FluidHelper.tryFluidTransfer(transferAmount < 0 ? underFluidHandler : heldFluidHandler, transferAmount < 0 ? heldFluidHandler : underFluidHandler, fluidStack = fluidStack.copy(fluidStack, Math.abs(transferAmount)), true) != null) {
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), transferAmount < 0 ? fluidStack.getEmptySound() : fluidStack.getFillSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                hoveredSlot.func_75215_d(underFluidHandler.getContainer());
                player.field_71071_by.func_70437_b(heldFluidHandler.getContainer());
                if (!(player instanceof EntityPlayerMP)) {
                    return;
                }
                player.field_71137_h = false;
                player.func_71113_k();
            });
            return null;
        }
    }
}

