/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders.network;

import bedrockbreaker.graduatedcylinders.api.IProxyFluidHandler;
import bedrockbreaker.graduatedcylinders.api.IProxyFluidHandlerItem;
import bedrockbreaker.graduatedcylinders.api.IProxyFluidStack;
import bedrockbreaker.graduatedcylinders.util.FluidHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketBlockTransferFluid
implements IMessage {
    private ItemStack heldItem;
    private int heldTankIndex;
    private BlockPos pos;
    private int side;
    private int blockTankIndex;
    private int amount;

    public PacketBlockTransferFluid() {
    }

    public PacketBlockTransferFluid(ItemStack heldItem, int heldTankIndex, BlockPos pos, int side, int blockTankIndex, int amount) {
        this.heldItem = heldItem;
        this.heldTankIndex = heldTankIndex;
        this.pos = pos;
        this.side = side;
        this.blockTankIndex = blockTankIndex;
        this.amount = amount;
    }

    public void fromBytes(ByteBuf buffer) {
        try {
            this.heldItem = new ItemStack(ByteBufUtils.readTag((ByteBuf)buffer));
            this.heldTankIndex = buffer.readInt();
            this.pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            this.side = buffer.readInt();
            this.blockTankIndex = buffer.readInt();
            this.amount = buffer.readInt();
        }
        catch (IndexOutOfBoundsException error) {
            System.out.println(error);
        }
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.heldItem.func_77955_b(new NBTTagCompound()));
        buffer.writeInt(this.heldTankIndex);
        buffer.writeInt(this.pos.func_177958_n());
        buffer.writeInt(this.pos.func_177956_o());
        buffer.writeInt(this.pos.func_177952_p());
        buffer.writeInt(this.side);
        buffer.writeInt(this.blockTankIndex);
        buffer.writeInt(this.amount);
    }

    public static class Handler
    implements IMessageHandler<PacketBlockTransferFluid, IMessage> {
        public IMessage onMessage(PacketBlockTransferFluid message, MessageContext ctx) {
            if (ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                if (message.amount == 0) {
                    return;
                }
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                int slot = -1;
                for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (stack.func_190926_b() || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)message.heldItem)) continue;
                    slot = i;
                    break;
                }
                if (slot == -1) {
                    return;
                }
                WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
                IProxyFluidHandlerItem heldFluidHandler = FluidHelper.getProxyFluidHandler(message.heldItem);
                IProxyFluidHandler blockFluidHandler = FluidHelper.getMatchingProxyFluidHandler((World)world, message.pos, EnumFacing.func_82600_a((int)message.side), heldFluidHandler);
                if (heldFluidHandler == null || blockFluidHandler == null) {
                    return;
                }
                IProxyFluidStack fluidStack = heldFluidHandler.getTankProperties(message.heldTankIndex).getContents();
                if (fluidStack == null) {
                    fluidStack = blockFluidHandler.getTankProperties(message.blockTankIndex).getContents();
                }
                if (fluidStack == null) {
                    return;
                }
                fluidStack = fluidStack.copy(fluidStack, Math.abs(message.amount));
                if (FluidHelper.tryFluidTransfer(message.amount < 0 ? blockFluidHandler : heldFluidHandler, message.amount < 0 ? heldFluidHandler : blockFluidHandler, fluidStack, true) != null) {
                    world.func_184133_a(null, player.func_180425_c(), message.amount < 0 ? fluidStack.getEmptySound() : fluidStack.getFillSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                world.func_175625_s(message.pos).func_70296_d();
                player.field_71071_by.func_70299_a(slot, heldFluidHandler.getContainer());
            });
            return null;
        }
    }
}

