/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders;

import bedrockbreaker.graduatedcylinders.api.IProxyFluidHandlerItem;
import bedrockbreaker.graduatedcylinders.api.IProxyFluidStack;
import bedrockbreaker.graduatedcylinders.api.MetaHandler;
import bedrockbreaker.graduatedcylinders.network.PacketContainerTransferFluid;
import bedrockbreaker.graduatedcylinders.network.PacketHandler;
import bedrockbreaker.graduatedcylinders.util.ColorCache;
import bedrockbreaker.graduatedcylinders.util.FluidHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="graduatedcylinders")
public class InventoryHandler {
    public static boolean clicked = false;

    @SubscribeEvent
    public static void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        IProxyFluidHandlerItem underFluidHandler;
        Minecraft minecraft = Minecraft.func_71410_x();
        GuiScreen screen = minecraft.field_71462_r;
        if (!(screen instanceof GuiContainer)) {
            return;
        }
        Slot hoveredSlot = ((GuiContainer)screen).getSlotUnderMouse();
        if (hoveredSlot == null || !hoveredSlot.func_111238_b() || !hoveredSlot.func_82869_a((EntityPlayer)minecraft.field_71439_g)) {
            return;
        }
        MetaHandler metaHandler = FluidHelper.getMetaHandler(minecraft.field_71439_g.field_71071_by.func_70445_o());
        if (metaHandler == null || !metaHandler.hasHandler(hoveredSlot.func_75211_c())) {
            return;
        }
        IProxyFluidHandlerItem heldFluidHandler = metaHandler.getHandler(minecraft.field_71439_g.field_71071_by.func_70445_o());
        int transferAmount = FluidHelper.getTransferAmount(heldFluidHandler, underFluidHandler = metaHandler.getHandler(hoveredSlot.func_75211_c()));
        if (transferAmount == 0) {
            return;
        }
        IProxyFluidStack fluid = heldFluidHandler.getTankProperties(0).getContents();
        if (fluid == null) {
            fluid = underFluidHandler.getTankProperties(0).getContents();
        }
        if (fluid == null) {
            throw new NullPointerException();
        }
        screen.func_146279_a(I18n.func_135052_a((String)"gc.inventory.rightclick", (Object[])new Object[]{transferAmount < 0 ? "->" : "<-", ColorCache.getFluidColorCode(fluid, fluid.getColor()) + TextFormatting.BOLD + metaHandler.modes.get(0).formatAmount(Math.abs(transferAmount), false) + TextFormatting.RESET}), event.getMouseX(), event.getMouseY());
    }

    @SubscribeEvent
    public static void onRightClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (Mouse.getEventButton() != 1) {
            return;
        }
        if (!Mouse.getEventButtonState()) {
            event.setCanceled(clicked);
            clicked = false;
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        GuiScreen screen = minecraft.field_71462_r;
        if (!(screen instanceof GuiContainer)) {
            return;
        }
        Slot hoveredSlot = ((GuiContainer)screen).getSlotUnderMouse();
        if (hoveredSlot == null || !hoveredSlot.func_111238_b() || !hoveredSlot.func_82869_a((EntityPlayer)minecraft.field_71439_g)) {
            return;
        }
        if (FluidHelper.getTransferAmount(FluidHelper.getProxyFluidHandler(minecraft.field_71439_g.field_71071_by.func_70445_o()), FluidHelper.getProxyFluidHandler(hoveredSlot.func_75211_c())) == 0) {
            return;
        }
        clicked = true;
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketContainerTransferFluid(hoveredSlot.field_75222_d));
        event.setCanceled(true);
    }
}

