/*
 * Decompiled with CFR 0.152.
 */
package bedrockbreaker.graduatedcylinders;

import bedrockbreaker.graduatedcylinders.api.IHandlerMode;
import bedrockbreaker.graduatedcylinders.api.IProxyFluidStack;
import bedrockbreaker.graduatedcylinders.api.MetaHandler;
import bedrockbreaker.graduatedcylinders.network.PacketBlockTransferFluid;
import bedrockbreaker.graduatedcylinders.network.PacketHandler;
import bedrockbreaker.graduatedcylinders.util.ColorCache;
import bedrockbreaker.graduatedcylinders.util.Expression;
import bedrockbreaker.graduatedcylinders.util.FluidHelper;
import bedrockbreaker.graduatedcylinders.util.GuiFluidSprite;
import bedrockbreaker.graduatedcylinders.util.MathHelper;
import bedrockbreaker.graduatedcylinders.util.Scene3DRenderer;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FluidTransferGui
extends GuiScreen {
    public boolean initialized = false;
    public final BlockPos pos;
    public final MetaHandler metaHandler;
    public final ItemStack heldItem;
    private final int heldTankCapacity;
    private ArrayList<ArrayList<Integer>> blockTankCapacities = new ArrayList();
    public EnumFacing selectedFace;
    public int heldTankIndex;
    public int blockTankIndex;
    private ArrayList<IProxyFluidStack> heldFluidStacks;
    private ArrayList<ArrayList<IProxyFluidStack>> sidedBlockFluidStacks;
    private ArrayList<ArrayList<FluidHelper.TransferrableFluidResult>> sidedTransferResults;
    private ArrayList<IProxyFluidStack> blockFluidStacks = new ArrayList();
    private HashMap<Pair<Integer, Integer>, FluidHelper.TransferrableFluidResult> transferResults = new HashMap();
    private ArrayList<FluidHelper.TransferrableFluidResult> allowedFaces = new ArrayList();
    private ArrayList<GuiFluidSprite> heldFluidSprites = new ArrayList();
    private ArrayList<GuiFluidSprite> blockFluidSprites = new ArrayList();
    private GuiFluidSprite hoveredSprite;
    private int numTransferrableHeldFluids;
    private int numTransferrableBlockFluids;
    public IHandlerMode mode;
    public int[] deltas;
    public ArrayList<String> deltaStrings = new ArrayList();
    public int maxAmount;
    public boolean transferDirectionForced;
    public boolean isExporting;
    public int amount = 0;
    private Scene3DRenderer sceneRenderer;
    private int buttonId = 0;
    private GuiTextField textAmount;
    private int instructionsWidth = 0;
    private GuiButton incFluidButton;
    private GuiButton decFluidButton;
    private GuiButton exportButton;
    private GuiButton modeButton;

    public static void open(ItemStack heldItem, BlockPos pos, ArrayList<ArrayList<FluidHelper.TransferrableFluidResult>> sidedTransferResults, int heldTankIndex, int side, int blockTankIndex, ArrayList<ArrayList<Integer>> blockTankCapacities, ArrayList<IProxyFluidStack> heldFluidStacks, ArrayList<ArrayList<IProxyFluidStack>> sidedBlockFluidStacks) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new FluidTransferGui(heldItem, pos, sidedTransferResults, heldTankIndex, side, blockTankIndex, blockTankCapacities, heldFluidStacks, sidedBlockFluidStacks));
    }

    public FluidTransferGui(ItemStack heldItem, BlockPos pos, ArrayList<ArrayList<FluidHelper.TransferrableFluidResult>> sidedTransferResults, int heldTankIndex, int side, int blockTankIndex, ArrayList<ArrayList<Integer>> blockTankCapacities, ArrayList<IProxyFluidStack> heldFluidStacks, ArrayList<ArrayList<IProxyFluidStack>> sidedBlockFluidStacks) {
        this.pos = pos;
        this.heldItem = heldItem;
        this.metaHandler = FluidHelper.getMetaHandler(heldItem);
        this.heldTankCapacity = this.metaHandler.getHandler(heldItem).getTankProperties(heldTankIndex).getCapacity();
        this.blockTankCapacities = blockTankCapacities;
        this.heldFluidStacks = heldFluidStacks;
        this.sidedBlockFluidStacks = sidedBlockFluidStacks;
        this.sidedTransferResults = sidedTransferResults;
        this.updateCaches(heldTankIndex, side, blockTankIndex);
        for (ArrayList<FluidHelper.TransferrableFluidResult> transferResults : sidedTransferResults) {
            FluidHelper.TransferrableFluidResult indices = new FluidHelper.TransferrableFluidResult(0, 0, false, false);
            for (FluidHelper.TransferrableFluidResult transferResult : transferResults) {
                if (!indices.canTransfer() && transferResult.canTransfer() || indices.canExport ^ indices.canImport && transferResult.canExport && transferResult.canImport) {
                    indices = transferResult;
                }
                if (!transferResult.canExport || !transferResult.canImport) continue;
                break;
            }
            this.allowedFaces.add(indices);
        }
        this.sceneRenderer = new Scene3DRenderer(pos, this.allowedFaces);
        this.sceneRenderer.selectedFace = EnumFacing.func_82600_a((int)side);
        this.initialized = true;
    }

    public void updateCaches(int heldTankIndex, int side, int blockTankIndex) {
        IProxyFluidStack fluidStack;
        int i;
        this.selectedFace = EnumFacing.func_82600_a((int)side);
        this.heldTankIndex = heldTankIndex;
        this.blockTankIndex = blockTankIndex;
        this.transferResults.clear();
        this.blockFluidStacks.clear();
        this.heldFluidSprites.clear();
        this.blockFluidSprites.clear();
        for (IProxyFluidStack fluidStack2 : this.sidedBlockFluidStacks.get(side)) {
            this.blockFluidStacks.add(fluidStack2);
        }
        for (FluidHelper.TransferrableFluidResult transferResult : this.sidedTransferResults.get(side)) {
            this.transferResults.put((Pair<Integer, Integer>)Pair.of((Object)transferResult.sourceTank, (Object)transferResult.destinationTank), transferResult);
        }
        int j = 0;
        for (i = 0; i < this.blockFluidStacks.size(); ++i) {
            GuiFluidSprite guiFluidSprite;
            fluidStack = this.blockFluidStacks.get(i);
            if (fluidStack == null) {
                guiFluidSprite = null;
            } else {
                ++j;
                guiFluidSprite = new GuiFluidSprite(fluidStack, 0.0f, 0.0f, 16.0f, 16.0f, i, j);
            }
            this.blockFluidSprites.add(guiFluidSprite);
        }
        j = 0;
        for (i = 0; i < this.heldFluidStacks.size(); ++i) {
            GuiFluidSprite guiFluidSprite;
            fluidStack = this.heldFluidStacks.get(i);
            if (fluidStack == null) {
                guiFluidSprite = null;
            } else {
                ++j;
                guiFluidSprite = new GuiFluidSprite(fluidStack, 0.0f, 0.0f, 16.0f, 16.0f, i, j);
            }
            this.heldFluidSprites.add(guiFluidSprite);
        }
    }

    protected boolean changeSelectedFace(EnumFacing face) {
        int side = face.func_176745_a();
        if (!this.allowedFaces.get(side).canTransfer()) {
            return false;
        }
        this.updateCaches(this.allowedFaces.get((int)side).sourceTank, side, this.allowedFaces.get((int)side).destinationTank);
        this.applyToSprites((sprite, isHeldSprite, isSelectedSprite, tankIndex) -> {
            sprite.setPos(this.field_146294_l / 2 - 18, this.field_146295_m / 2 - (this.isExporting ^ isHeldSprite ? 44 : 76));
            if (this.isExporting ^ isHeldSprite) {
                sprite.setOpacity(0);
            }
        });
        this.initFluidSprites(false);
        this.selectFluid((Pair<Integer, Integer>)Pair.of((Object)this.allowedFaces.get((int)side).sourceTank, (Object)this.allowedFaces.get((int)side).destinationTank), 0, this.isExporting, true);
        return true;
    }

    protected void applyToSprites(SpriteConsumer lambda) {
        GuiFluidSprite sprite;
        int i;
        for (i = 0; i < this.heldFluidSprites.size(); ++i) {
            sprite = this.heldFluidSprites.get(i);
            if (sprite == null) continue;
            lambda.apply(sprite, true, i == this.heldTankIndex, i);
        }
        for (i = 0; i < this.blockFluidSprites.size(); ++i) {
            sprite = this.blockFluidSprites.get(i);
            if (sprite == null) continue;
            lambda.apply(sprite, false, i == this.blockTankIndex, i);
        }
    }

    protected void toggleTransferDirection() {
        if (this.transferDirectionForced) {
            return;
        }
        this.isExporting = !this.isExporting;
        this.exportButton.field_146126_j = this.isExporting ? "->" : "<-";
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        this.applyToSprites((sprite, isHeldSprite, isSelectedSprite, tankIndex) -> {
            if (isSelectedSprite && sprite.fluidStack.isFluidEqual(isHeldSprite ? this.blockFluidStacks.get(this.blockTankIndex) : this.heldFluidStacks.get(this.heldTankIndex))) {
                sprite.animateMove(centerX - 26, centerY - 92);
                sprite.setOpacity(this.isExporting ^ isHeldSprite ? 0 : 255);
            } else {
                if (!(this.isExporting ^ isHeldSprite)) {
                    sprite.y = centerY - 108;
                }
                sprite.animateMove(centerX + sprite.renderIndex * 24 + (sprite.renderIndex < 0 ? -30 : -6), centerY + (this.isExporting ^ isHeldSprite ? -44 : -76));
                sprite.animateOpacity(this.isExporting ^ isHeldSprite ? 0 : 255);
                if (isSelectedSprite) {
                    sprite.startY -= 32.0f;
                    sprite.endY -= 16.0f;
                }
            }
        });
        if (!this.textAmount.func_146179_b().contains("%")) {
            return;
        }
        double output = Math.round(Expression.evaluate(this.textAmount.func_146179_b(), new Expression.Context().setPercent(this.isExporting ? (double)this.heldFluidStacks.get(this.heldTankIndex).getAmount() : (double)this.blockFluidStacks.get(this.blockTankIndex).getAmount())));
        if (output < 0.0 || Double.isNaN(output)) {
            return;
        }
        this.amount = MathHelper.clamp((int)output, 0, this.maxAmount);
    }

    protected void cycleMode() {
        this.mode = this.metaHandler.modes.get((this.metaHandler.modes.indexOf(this.mode) + 1) % this.metaHandler.modes.size());
        this.deltas = this.mode.getDeltas(this.amount, this.heldTankCapacity, this.blockTankCapacities.get(this.selectedFace.func_176745_a()).get(this.blockTankIndex));
        this.deltaStrings = this.mode.getStringDeltas();
        this.instructionsWidth = 0;
        this.deltaStrings.forEach(s -> {
            this.instructionsWidth = Math.max(this.instructionsWidth, this.field_146289_q.func_78256_a(s));
        });
        this.instructionsWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)("gc.gui.combo6" + (Minecraft.field_142025_a ? ".cmd" : "")), (Object[])new Object[0])) + this.instructionsWidth + 10;
    }

    protected void selectFluid(Pair<Integer, Integer> tankIndices, int fluidTransferAmount, boolean defaultTransferDirection, boolean doAnimation) {
        int heldTankRelativeIndexOld = this.heldFluidSprites.get(this.heldTankIndex) == null ? 0 : this.heldFluidSprites.get((int)this.heldTankIndex).renderIndex;
        int blockTankRelativeIndexOld = this.blockFluidSprites.get(this.blockTankIndex) == null ? 0 : this.blockFluidSprites.get((int)this.blockTankIndex).renderIndex;
        this.applyToSprites((sprite, isHeldSprite, isSelectedSprite, tankIndex) -> {
            sprite.renderIndex = sprite.renderIndex + (isHeldSprite ? heldTankRelativeIndexOld : blockTankRelativeIndexOld);
        });
        this.heldTankIndex = (Integer)tankIndices.getLeft();
        this.blockTankIndex = (Integer)tankIndices.getRight();
        this.allowedFaces.set(this.selectedFace.func_176745_a(), this.getTransferCapability());
        this.maxAmount = Math.min(this.heldTankCapacity, this.blockTankCapacities.get(this.selectedFace.func_176745_a()).get(this.blockTankIndex));
        this.transferDirectionForced = this.getTransferCapability().canExport ^ this.getTransferCapability().canImport;
        this.isExporting = this.transferDirectionForced ? this.getTransferCapability().canExport : defaultTransferDirection;
        this.exportButton.field_146126_j = this.isExporting ? "->" : "<-";
        this.exportButton.field_146124_l = !this.transferDirectionForced;
        this.setAmount(fluidTransferAmount);
        this.deltas = this.mode.getDeltas(this.amount, this.heldTankCapacity, this.blockTankCapacities.get(this.selectedFace.func_176745_a()).get(this.blockTankIndex));
        this.initFluidSprites(doAnimation);
    }

    protected FluidHelper.TransferrableFluidResult getTransferCapability() {
        return this.transferResults.get(Pair.of((Object)this.heldTankIndex, (Object)this.blockTankIndex));
    }

    protected IProxyFluidStack getWorkingFluidStack() {
        return this.getTransferCapability().canExport ? this.heldFluidStacks.get(this.heldTankIndex) : (this.getTransferCapability().canImport ? this.blockFluidStacks.get(this.blockTankIndex) : null);
    }

    public void func_73866_w_() {
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        this.incFluidButton = new GuiButton(this.buttonId++, centerX + 50, centerY - 35, 20, 20, "+");
        this.func_189646_b(this.incFluidButton);
        this.decFluidButton = new GuiButton(this.buttonId++, centerX + 50, centerY - 5, 20, 20, "-");
        this.func_189646_b(this.decFluidButton);
        this.exportButton = new GuiButton(this.buttonId++, centerX - 72, centerY + 28, 20, 20, this.isExporting ? "->" : "<-");
        this.func_189646_b(this.exportButton);
        this.modeButton = new GuiButton(this.buttonId++, centerX - 90, centerY - 20, 20, 20, "");
        if (this.metaHandler.modes.size() > 1) {
            this.func_189646_b(this.modeButton);
        }
        this.cycleMode();
        this.textAmount = new GuiTextField(0, this.field_146289_q, centerX - 60, centerY - 20, 100, 20);
        this.textAmount.func_146180_a(Integer.toString(this.amount));
        this.textAmount.func_146195_b(true);
        this.textAmount.func_146205_d(false);
        this.selectFluid((Pair<Integer, Integer>)Pair.of((Object)this.heldTankIndex, (Object)this.blockTankIndex), 0, Minecraft.func_71410_x().field_71439_g.func_70093_af(), false);
        this.sceneRenderer.init();
    }

    private void initFluidSprites(boolean doAnimation) {
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        this.numTransferrableHeldFluids = 0;
        this.numTransferrableBlockFluids = 0;
        int heldTankRelativeIndex = this.heldFluidSprites.get(this.heldTankIndex) == null ? 0 : this.heldFluidSprites.get((int)this.heldTankIndex).renderIndex;
        int blockTankRelativeIndex = this.blockFluidSprites.get(this.blockTankIndex) == null ? 0 : this.blockFluidSprites.get((int)this.blockTankIndex).renderIndex;
        this.applyToSprites((sprite, isHeldSprite, isSelectedSprite, tankIndex) -> {
            sprite.renderIndex = sprite.renderIndex - (isHeldSprite ? heldTankRelativeIndex : blockTankRelativeIndex);
            if (isSelectedSprite) {
                sprite.animateMove(centerX - 26, centerY - 92);
                sprite.animateScale(32.0f, 32.0f);
                sprite.animateOpacity(this.isExporting ^ isHeldSprite ? 0 : 255);
            } else {
                sprite.animateMove(centerX + sprite.renderIndex * 24 + (sprite.renderIndex < 0 ? -26 : -10), centerY - (this.isExporting ^ isHeldSprite ? 44 : 76));
                sprite.animateScale(16.0f, 16.0f);
                sprite.animateOpacity(this.isExporting ^ isHeldSprite ? 0 : 255);
            }
            if (!doAnimation) {
                sprite.elapsedTime = sprite.transitionLength;
            }
            if (this.isExporting ^ isHeldSprite) {
                return;
            }
            FluidHelper.TransferrableFluidResult transferResult = this.transferResults.get(Pair.of((Object)(isHeldSprite ? tankIndex : this.heldTankIndex), (Object)(isHeldSprite ? this.blockTankIndex : tankIndex)));
            if (transferResult.canExport) {
                ++this.numTransferrableHeldFluids;
            }
            if (transferResult.canImport) {
                ++this.numTransferrableBlockFluids;
            }
        });
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        float scale = new ScaledResolution(Minecraft.func_71410_x()).func_78325_e();
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        String cmd = Minecraft.field_142025_a ? ".cmd" : "";
        int leftMargin = this.field_146294_l - this.instructionsWidth;
        this.func_146276_q_();
        this.textAmount.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String displayHeldAmount = this.mode.formatAmount(this.heldFluidStacks.get(this.heldTankIndex) != null ? this.heldFluidStacks.get(this.heldTankIndex).getAmount() : 0, false);
        this.func_73732_a(this.field_146289_q, displayHeldAmount, centerX - 98 - Math.max(this.field_146289_q.func_78256_a(displayHeldAmount) / 2 - 26, 0), centerY + 75, 0xAAAAAA);
        String displayBlockAmount = this.mode.formatAmount(this.blockFluidStacks.get(this.blockTankIndex) != null ? this.blockFluidStacks.get(this.blockTankIndex).getAmount() : 0, false);
        this.func_73732_a(this.field_146289_q, displayBlockAmount, centerX - 10 + Math.max(this.field_146289_q.func_78256_a(displayBlockAmount) / 2 - 42, 0), centerY + 75, 0xAAAAAA);
        if (this.amount > 0) {
            int heldAmount = this.heldFluidStacks.get(this.heldTankIndex) != null ? this.heldFluidStacks.get(this.heldTankIndex).getAmount() : 0;
            int blockAmount = this.blockFluidStacks.get(this.blockTankIndex) != null ? this.blockFluidStacks.get(this.blockTankIndex).getAmount() : 0;
            int deltaMax = Math.min(this.isExporting ? Math.min(this.blockTankCapacities.get(this.selectedFace.func_176745_a()).get(this.blockTankIndex) - blockAmount, heldAmount) : Math.min(this.heldTankCapacity - heldAmount, blockAmount), this.amount);
            String displayHeldAmountNew = this.mode.formatAmount(heldAmount + (this.isExporting ? -deltaMax : deltaMax), false);
            this.func_73732_a(this.field_146289_q, displayHeldAmountNew, centerX - 98 - Math.max(this.field_146289_q.func_78256_a(displayHeldAmountNew) / 2 - 26, 0), centerY + 90, this.isExporting ? 0xAA0000 : 43520);
            String displayTankAmountNew = this.mode.formatAmount(blockAmount + (this.isExporting ? deltaMax : -deltaMax), false);
            this.func_73732_a(this.field_146289_q, displayTankAmountNew, centerX - 10 + Math.max(this.field_146289_q.func_78256_a(displayTankAmountNew) / 2 - 42, 0), centerY + 90, this.isExporting ? 43520 : 0xAA0000);
        }
        String displayAmount = this.mode.formatAmount(this.amount, true);
        this.func_73731_b(this.field_146289_q, displayAmount, centerX - 56 - Math.max(this.field_146289_q.func_78256_a(displayAmount) - 96, 0), centerY - 30, 0xAAAAAA);
        this.func_73732_a(this.field_146289_q, this.getColorizedFluidName(this.getWorkingFluidStack()), centerX - 10, centerY - 50, 0xFFFFFF);
        int h = -10;
        this.drawRightAlignedString(I18n.func_135052_a((String)"gc.gui.instructions", (Object[])new Object[0]), this.field_146294_l - 5, h += 15, 0xAAAAAA);
        if (!this.transferDirectionForced) {
            this.drawRightAlignedString(I18n.func_135052_a((String)"gc.gui.toggle", (Object[])new Object[]{settings.field_74314_A.getDisplayName()}), this.field_146294_l - 5, h += 15, 0xAAAAAA);
        }
        if (this.numTransferrableHeldFluids > 1 || this.numTransferrableBlockFluids > 1) {
            this.drawRightAlignedString(I18n.func_135052_a((String)"gc.gui.cycle", (Object[])new Object[0]), this.field_146294_l - 5, h += 15, 0xAAAAAA);
        }
        this.drawRightAlignedString(I18n.func_135052_a((String)"gc.gui.accept", (Object[])new Object[]{settings.field_151445_Q.getDisplayName()}), this.field_146294_l - 5, h += 15, 0xAAAAAA);
        this.drawRightAlignedString(I18n.func_135052_a((String)"gc.gui.cancel", (Object[])new Object[0]), this.field_146294_l - 5, h += 15, 0xAAAAAA);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)("gc.gui.combo1" + cmd), (Object[])new Object[0]), leftMargin, this.field_146295_m - 105, 0xAAAAAA);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)("gc.gui.combo2" + cmd), (Object[])new Object[0]), leftMargin, this.field_146295_m - 90, 0xAAAAAA);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gc.gui.combo3", (Object[])new Object[0]), leftMargin, this.field_146295_m - 75, 0xAAAAAA);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gc.gui.combo4", (Object[])new Object[0]), leftMargin, this.field_146295_m - 60, 0xAAAAAA);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gc.gui.combo5", (Object[])new Object[0]), leftMargin, this.field_146295_m - 45, 0xAAAAAA);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)("gc.gui.combo6" + cmd), (Object[])new Object[0]), leftMargin, this.field_146295_m - 30, 0xAAAAAA);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gc.gui.combo7", (Object[])new Object[0]), leftMargin, this.field_146295_m - 15, 0xAAAAAA);
        this.drawRightAlignedString(this.deltaStrings.get(0), this.field_146294_l - 5, this.field_146295_m - 105, 0xAAAAAA);
        this.drawRightAlignedString(this.deltaStrings.get(1), this.field_146294_l - 5, this.field_146295_m - 90, 0xAAAAAA);
        this.drawRightAlignedString(this.deltaStrings.get(2), this.field_146294_l - 5, this.field_146295_m - 75, 0xAAAAAA);
        this.drawRightAlignedString(this.deltaStrings.get(3), this.field_146294_l - 5, this.field_146295_m - 60, 0xAAAAAA);
        this.drawRightAlignedString(this.deltaStrings.get(4), this.field_146294_l - 5, this.field_146295_m - 45, 0xAAAAAA);
        this.drawRightAlignedString(this.deltaStrings.get(5), this.field_146294_l - 5, this.field_146295_m - 30, 0xAAAAAA);
        this.drawRightAlignedString(this.deltaStrings.get(6), this.field_146294_l - 5, this.field_146295_m - 15, 0xAAAAAA);
        this.drawItemStack(this.heldItem, centerX - 114, centerY + 22, 2.0f);
        if (this.metaHandler.modes.size() > 1) {
            this.drawItemStack(this.mode.getModeIcon(), centerX - 88, centerY - 18);
        }
        RenderHelper.func_74518_a();
        this.applyToSprites((sprite, isHeldSprite, isSelectedSprite, tankIndex) -> sprite.render(partialTicks));
        GuiFluidSprite previousHoveredSprite = this.hoveredSprite;
        this.hoveredSprite = null;
        this.applyToSprites((sprite, isHeldSprite, isSelectedSprite, tankIndex) -> {
            if (sprite.isMouseOver(mouseX, mouseY) && !(this.isExporting ^ isHeldSprite)) {
                ArrayList<String> textLines = new ArrayList<String>();
                textLines.add(this.getColorizedFluidName(sprite.fluidStack));
                textLines.add(TextFormatting.GRAY + this.mode.formatAmount(sprite.fluidStack.getAmount(), false));
                if (!isSelectedSprite) {
                    this.hoveredSprite = sprite;
                    FluidHelper.TransferrableFluidResult transferResult = this.transferResults.get(Pair.of((Object)(isHeldSprite ? tankIndex : this.heldTankIndex), (Object)(isHeldSprite ? this.blockTankIndex : tankIndex)));
                    textLines.add(I18n.func_135052_a((String)(transferResult.canTransfer() ? "gc.gui.selectfluid" : "gc.gui.fluidblocked"), (Object[])new Object[]{TextFormatting.RED, TextFormatting.GRAY.toString() + TextFormatting.ITALIC}));
                } else {
                    textLines.add(I18n.func_135052_a((String)"gc.gui.selected", (Object[])new Object[]{TextFormatting.GRAY.toString() + TextFormatting.ITALIC}));
                }
                this.func_146283_a(textLines, mouseX, mouseY);
            }
        });
        if (previousHoveredSprite != this.hoveredSprite) {
            this.applyToSprites((sprite, isHeldSprite, isSelectedSprite, tankIndex) -> {
                if (this.hoveredSprite == null) {
                    if (isSelectedSprite) {
                        sprite.animateMove(centerX - 26, centerY - 92);
                        sprite.animateScale(32.0f, 32.0f);
                    } else {
                        sprite.animateMove(centerX + sprite.renderIndex * 24 + (sprite.renderIndex < 0 ? -26 : -10), centerY + (this.isExporting ^ isHeldSprite ? -44 : -76));
                        sprite.animateScale(16.0f, 16.0f);
                    }
                } else if (sprite == this.hoveredSprite) {
                    sprite.animateMove(centerX + sprite.renderIndex * 24 - 26, centerY + (this.isExporting ^ isHeldSprite ? -60 : -92));
                    sprite.animateScale(32.0f, 32.0f);
                } else if (isSelectedSprite) {
                    sprite.animateMove(centerX - 26 + (this.hoveredSprite.renderIndex < 0 ? 16 : 0), centerY - 76);
                    sprite.animateScale(16.0f, 16.0f);
                } else {
                    sprite.animateMove(centerX + sprite.renderIndex * 24 + (sprite.renderIndex < 0 ? -26 : -10) + (this.hoveredSprite.renderIndex < 0 ? (sprite.renderIndex > this.hoveredSprite.renderIndex && sprite.renderIndex < 0 ? 16 : 0) : (sprite.renderIndex < this.hoveredSprite.renderIndex && sprite.renderIndex > 0 ? -16 : 0)), centerY + (this.isExporting ^ isHeldSprite ? -44 : -76));
                    sprite.animateScale(16.0f, 16.0f);
                }
            });
        }
        RenderHelper.func_74520_c();
        int sceneX = centerX - 42;
        int sceneY = centerY + 6;
        int sceneWidth = 64;
        int sceneHeight = 64;
        Gui.func_73734_a((int)(sceneX - 1), (int)(sceneY - 2), (int)(sceneX + 64 + 1), (int)(sceneY - 1), (int)-267386864);
        Gui.func_73734_a((int)(sceneX - 1), (int)(sceneY + 64 + 1), (int)(sceneX + 64 + 1), (int)(sceneY + 64 + 2), (int)-267386864);
        Gui.func_73734_a((int)(sceneX - 2), (int)(sceneY - 1), (int)(sceneX - 1), (int)(sceneY + 64 + 1), (int)-267386864);
        Gui.func_73734_a((int)(sceneX + 64 + 1), (int)(sceneY - 1), (int)(sceneX + 64 + 2), (int)(sceneY + 64 + 1), (int)-267386864);
        Gui.func_73734_a((int)(sceneX - 1), (int)(sceneY - 1), (int)(sceneX + 64 + 1), (int)(sceneY + 64 + 1), (int)-16777216);
        Gui.func_73734_a((int)(sceneX - 1), (int)(sceneY - 1), (int)(sceneX + 64 + 1), (int)sceneY, (int)0x505000FF);
        Gui.func_73734_a((int)(sceneX - 1), (int)(sceneY + 64), (int)(sceneX + 64 + 1), (int)(sceneY + 64 + 1), (int)1344798847);
        this.func_73733_a(sceneX - 1, sceneY, sceneX, sceneY + 64, 0x505000FF, 1344798847);
        this.func_73733_a(sceneX + 64, sceneY, sceneX + 64 + 1, sceneY + 64, 0x505000FF, 1344798847);
        this.sceneRenderer.drawScreen(partialTicks, new Rectangle((int)((float)sceneX * scale), (int)((float)(this.field_146295_m - sceneY - 64) * scale), (int)(64.0f * scale), (int)(64.0f * scale)));
        if (mouseX >= centerX - 114 && mouseX < centerX - 82 && mouseY >= centerY + 22 && mouseY < centerY + 54) {
            this.func_146285_a(this.heldItem, mouseX, mouseY);
        }
        if (this.exportButton.func_146115_a()) {
            this.func_146279_a(I18n.func_135052_a((String)(this.transferDirectionForced ? "gc.gui.notoggle" : "gc.gui.yestoggle"), (Object[])new Object[0]), mouseX, mouseY);
        }
        if (this.modeButton.func_146115_a()) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(this.mode.getModeName());
            lines.add(I18n.func_135052_a((String)"gc.gui.cyclemode", (Object[])new Object[]{settings.field_74314_A.getDisplayName()}));
            this.func_146283_a(lines, mouseX, mouseY);
        }
        if (this.sceneRenderer.hoveredFace != null && !this.allowedFaces.get(this.sceneRenderer.hoveredFace.func_176745_a()).canTransfer()) {
            this.func_146279_a(I18n.func_135052_a((String)"gc.gui.sideblocked", (Object[])new Object[]{TextFormatting.RED, TextFormatting.GRAY.toString() + TextFormatting.ITALIC}), sceneX + 64, sceneY + 32 + 5);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.incFluidButton) {
            this.setAmount(this.amount + this.getDelta());
        } else if (button == this.decFluidButton) {
            this.setAmount(this.amount - this.getDelta());
        } else if (button == this.exportButton) {
            this.toggleTransferDirection();
        } else if (button == this.modeButton) {
            this.cycleMode();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.handleKeyInput(typedChar, keyCode);
    }

    public void func_146274_d() throws IOException {
        Pair tankIndices;
        FluidHelper.TransferrableFluidResult transferResult;
        if (!this.initialized) {
            return;
        }
        int scrollAmount = Mouse.getDWheel();
        if (scrollAmount != 0) {
            this.setAmount(this.amount + this.getDelta() * MathHelper.clamp(scrollAmount, -1, 1));
        }
        if ((Mouse.getEventButton() == 0 || Mouse.getEventButton() == 1) && Mouse.getEventButtonState() && this.hoveredSprite != null && (transferResult = this.transferResults.get(tankIndices = Pair.of((Object)(this.isExporting ? this.hoveredSprite.tankIndex : this.heldTankIndex), (Object)(this.isExporting ? this.blockTankIndex : this.hoveredSprite.tankIndex)))).canTransfer()) {
            this.selectFluid((Pair<Integer, Integer>)tankIndices, Mouse.getEventButton() == 0 ? this.amount : this.hoveredSprite.fluidStack.getAmount(), this.isExporting, true);
        }
        this.sceneRenderer.handleMouseinput();
        if (this.sceneRenderer.selectedFace != this.selectedFace) {
            this.changeSelectedFace(this.sceneRenderer.selectedFace);
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.textAmount.func_146192_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 1 && (this.isExporting ? this.heldFluidSprites.get(this.heldTankIndex) : this.blockFluidSprites.get(this.blockTankIndex)).isMouseOver(mouseX, mouseY)) {
            this.setAmount((this.isExporting ? this.heldFluidStacks.get(this.heldTankIndex) : this.blockFluidStacks.get(this.blockTankIndex)).getAmount());
        }
        this.handleKeyInput(mouseButton - 100, mouseX, mouseY);
    }

    private void handleKeyInput(char typedChar, int keyCode, int mouseX, int mouseY) {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        if (keyCode == settings.field_151445_Q.func_151463_i()) {
            Minecraft.func_71410_x().func_147108_a(null);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketBlockTransferFluid(this.heldItem, this.heldTankIndex, this.pos, this.selectedFace.func_176745_a(), this.blockTankIndex, this.amount * (this.isExporting ? -1 : 1)));
        } else if (keyCode == settings.field_74314_A.func_151463_i()) {
            if (GuiScreen.func_146272_n()) {
                this.cycleMode();
            } else {
                this.toggleTransferDirection();
            }
        } else if (keyCode == settings.field_74351_w.func_151463_i() || keyCode == 200) {
            this.setAmount(this.amount + this.getDelta());
        } else if (keyCode == settings.field_74368_y.func_151463_i() || keyCode == 208) {
            this.setAmount(this.amount - this.getDelta());
        } else if (keyCode == settings.field_74370_x.func_151463_i()) {
            this.textAmount.func_146201_a('\u0000', 203);
        } else if (keyCode == settings.field_74366_z.func_151463_i()) {
            this.textAmount.func_146201_a('\u0000', 205);
        } else if (keyCode == 15) {
            int numTanks = this.isExporting ? this.heldFluidStacks.size() : this.blockFluidStacks.size();
            int tankIndex = this.isExporting ? this.heldTankIndex : this.blockTankIndex;
            int direction = GuiScreen.func_146272_n() ? -1 : 1;
            int i = (tankIndex + direction + numTanks) % numTanks;
            while (i != tankIndex) {
                Pair tankIndices;
                FluidHelper.TransferrableFluidResult transferResult;
                GuiFluidSprite sprite;
                GuiFluidSprite guiFluidSprite = sprite = this.isExporting ? this.heldFluidSprites.get(i) : this.blockFluidSprites.get(i);
                if (sprite != null && (transferResult = this.transferResults.get(tankIndices = Pair.of((Object)(this.isExporting ? sprite.tankIndex : this.heldTankIndex), (Object)(this.isExporting ? this.blockTankIndex : sprite.tankIndex)))).canTransfer()) {
                    this.selectFluid((Pair<Integer, Integer>)tankIndices, this.amount, this.isExporting, true);
                    break;
                }
                i = (i + direction + numTanks) % numTanks;
            }
        } else if (keyCode == -99) {
            if (mouseX < this.textAmount.field_146209_f || mouseX >= this.textAmount.field_146209_f + this.textAmount.field_146218_h || mouseY < this.textAmount.field_146210_g || mouseY >= this.textAmount.field_146210_g + this.textAmount.field_146219_i) {
                return;
            }
            this.setAmount(0);
            this.textAmount.func_146180_a("");
        } else {
            int leadCount;
            this.textAmount.func_146201_a(typedChar, keyCode);
            double output = Math.round(Expression.evaluate(this.textAmount.func_146179_b(), new Expression.Context().setPercent(this.isExporting ? (double)this.heldFluidStacks.get(this.heldTankIndex).getAmount() : (double)this.blockFluidStacks.get(this.blockTankIndex).getAmount())));
            if (output < 0.0 || Double.isNaN(output)) {
                return;
            }
            this.amount = MathHelper.clamp((int)output, 0, this.maxAmount);
            if (keyCode == 28) {
                this.textAmount.func_146180_a(String.valueOf(this.amount));
            }
            if (!this.textAmount.func_146179_b().startsWith("0") || !NumberUtils.isDigits((String)Character.toString(typedChar))) {
                return;
            }
            int cursorPos = this.textAmount.func_146198_h();
            for (leadCount = 0; leadCount < this.textAmount.func_146179_b().length() - 1 && this.textAmount.func_146179_b().charAt(leadCount) == '0'; ++leadCount) {
            }
            this.textAmount.func_146180_a(this.textAmount.func_146179_b().substring(leadCount));
            this.textAmount.func_146190_e(Math.max(cursorPos - leadCount, 0));
        }
    }

    private void handleKeyInput(char typedChar, int keyCode) {
        this.handleKeyInput(typedChar, keyCode, -1, -1);
    }

    private void handleKeyInput(int keyCode, int mouseX, int mouseY) {
        this.handleKeyInput('\u0000', keyCode, mouseX, mouseY);
    }

    private void drawRightAlignedString(String text, int x, int y, int color) {
        this.func_73731_b(this.field_146289_q, text, x - this.field_146289_q.func_78256_a(text), y, color);
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        this.drawItemStack(stack, x, y, 1.0f);
    }

    private void drawItemStack(ItemStack stack, float x, float y, float scale) {
        x /= scale;
        y /= scale;
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, (int)x, (int)y);
        this.field_146296_j.func_180453_a(font, stack, (int)x, (int)y, "");
        RenderHelper.func_74520_c();
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    private void setAmount(int amountIn) {
        this.amount = MathHelper.clamp(amountIn, 0, this.maxAmount);
        this.textAmount.func_146180_a(Integer.toString(this.amount));
    }

    private int getDelta() {
        return FluidTransferGui.func_146272_n() ? (FluidTransferGui.func_146271_m() ? (FluidTransferGui.func_175283_s() ? this.deltas[5] : this.deltas[0]) : (FluidTransferGui.func_175283_s() ? this.deltas[4] : this.deltas[2])) : (FluidTransferGui.func_146271_m() ? this.deltas[1] : (FluidTransferGui.func_175283_s() ? this.deltas[6] : this.deltas[3]));
    }

    private String getColorizedFluidName(IProxyFluidStack fluidStack) {
        return ColorCache.getFluidColorCode(fluidStack, fluidStack.getColor()) + TextFormatting.UNDERLINE + fluidStack.getLocalizedName() + TextFormatting.RESET;
    }

    @FunctionalInterface
    private static interface SpriteConsumer {
        public void apply(GuiFluidSprite var1, boolean var2, boolean var3, int var4);
    }
}

