/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.colouredtooltips;

import java.awt.Color;
import java.io.File;
import net.darkhax.colouredtooltips.ColouredTooltips;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration config;
    public static long start;
    public static long end;
    public static long background;

    public ConfigurationHandler(File file) {
        config = new Configuration(file);
        config.setCategoryComment("general", "Color values are ARGB hex. Do not add a # to the codes. If you want opaque RGB use FF for first two chars.");
        this.syncConfigData();
    }

    private void syncConfigData() {
        start = this.getColor("borderStart", "505000ff", "top");
        end = this.getColor("borderEnd", "5028007f", "bottom");
        background = this.getColor("background", "f0100010", "background");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public long getColor(String name, String defaultValue, String explain) {
        String colorValue = "0x" + config.getString(name, "general", defaultValue, "The color for the " + explain + " of the tooltip. This should be 8 characters.");
        try {
            return Long.decode(colorValue);
        }
        catch (Exception e) {
            ColouredTooltips.LOG.trace("Could not read color for " + name + ". Invalid color: " + colorValue + " Default: " + defaultValue, (Throwable)e);
            return Color.WHITE.getRGB();
        }
    }
}

