/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.nutrients;

import ca.wescook.nutrition.api.INutrient;
import ca.wescook.nutrition.api.INutritionFood;
import ca.wescook.nutrition.api.NutritionUtil;
import ca.wescook.nutrition.capabilities.INutrientManager;
import ca.wescook.nutrition.nutrients.FoodHintList;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.nutrients.NutritionAdapterManager;
import ca.wescook.nutrition.proxy.ClientProxy;
import ca.wescook.nutrition.utility.Config;
import com.google.common.primitives.Floats;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCake;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class NutritionUtilImpl {
    @CapabilityInject(value=INutrientManager.class)
    private static final Capability<INutrientManager> NUTRITION_CAPABILITY = null;

    public static Map<Nutrient, Float> calculateNutrition(ItemStack itemStack, @Nullable EntityPlayer player) {
        LinkedHashMap<Nutrient, Float> result = new LinkedHashMap<Nutrient, Float>();
        for (Nutrient nutrient : NutrientList.get()) {
            Float nutrientValue = NutritionUtilImpl.getNutritionValue(nutrient, itemStack, player);
            if (nutrientValue == null) continue;
            result.put(nutrient, nutrientValue);
        }
        NutritionUtilImpl.applyNutritionLoss(result);
        return result;
    }

    @Nullable
    private static Float getNutritionValue(Nutrient nutrient, ItemStack itemStack, @Nullable EntityPlayer player) {
        Float nutrientScale = nutrient.getNutrientScale(itemStack);
        if (nutrientScale == null) {
            return null;
        }
        float baseFoodValue = NutritionUtilImpl.getBaseFoodValue(itemStack, player);
        float adjustedFoodValue = NutritionUtilImpl.adjustFoodValue(baseFoodValue);
        return Float.valueOf(adjustedFoodValue * nutrientScale.floatValue());
    }

    private static float getBaseFoodValue(ItemStack itemStack, @Nullable EntityPlayer player) {
        INutritionFood adapted = NutritionAdapterManager.apply(itemStack);
        if (adapted != null) {
            return adapted.getHealAmount(itemStack, player);
        }
        Float healAmount = FoodHintList.getHealAmount(itemStack);
        if (healAmount != null) {
            return healAmount.floatValue();
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof INutritionFood) {
            return ((INutritionFood)item).getHealAmount(itemStack, player);
        }
        if (item instanceof ItemFood) {
            return ((ItemFood)item).func_150905_g(itemStack);
        }
        if (item instanceof ItemBlock || item instanceof ItemBlockSpecial) {
            return 2.0f;
        }
        if (item instanceof ItemBucketMilk) {
            return 4.0f;
        }
        return 0.0f;
    }

    private static float adjustFoodValue(float baseFoodValue) {
        float adjustedFoodValue = baseFoodValue * 0.5f;
        return adjustedFoodValue *= Config.nutritionMultiplier;
    }

    private static void applyNutritionLoss(Map<Nutrient, Float> nutritionValues) {
        float lossRatio = NutritionUtilImpl.getLossRatio(nutritionValues.size());
        nutritionValues.replaceAll((nutrition, nutritionValue) -> Float.valueOf(nutritionValue.floatValue() * (1.0f - lossRatio)));
    }

    private static float getLossRatio(int nutritionNum) {
        return Math.min(1.0f, (float)Config.lossPerNutrient / 100.0f * (float)(nutritionNum - 1));
    }

    public static boolean isValidFood(ItemStack itemStack) {
        INutritionFood adapted = NutritionAdapterManager.apply(itemStack);
        if (adapted != null) {
            return true;
        }
        Boolean result = FoodHintList.isValidFood(itemStack);
        if (result != null) {
            return result;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemFood) {
            return true;
        }
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof BlockCake) {
            return true;
        }
        if (item instanceof ItemBlockSpecial && ((ItemBlockSpecial)item).getBlock() instanceof BlockCake) {
            return true;
        }
        if (item instanceof ItemBucketMilk) {
            return true;
        }
        return item instanceof INutritionFood;
    }

    public static boolean addNutrientsToPlayer(EntityPlayer player, ItemStack itemStack) {
        if (!NutritionUtil.isValidFood(itemStack)) {
            return false;
        }
        Map<Nutrient, Float> nutrientValues = NutritionUtilImpl.calculateNutrition(itemStack, player);
        INutrientManager nutrientManager = NutritionUtilImpl.getNutrientManager(player);
        nutrientManager.add(nutrientValues);
        return true;
    }

    public static float getNutrient(EntityPlayer player, INutrient nutrient) {
        INutrientManager nutrientManager = NutritionUtilImpl.getNutrientManager(player);
        return nutrientManager.get((Nutrient)nutrient).floatValue();
    }

    public static void setNutrient(EntityPlayer player, INutrient nutrient, float value) {
        INutrientManager nutrientManager = NutritionUtilImpl.getNutrientManager(player);
        nutrientManager.set((Nutrient)nutrient, Float.valueOf(Floats.constrainToRange((float)value, (float)0.0f, (float)100.0f)));
    }

    public static void addNutrient(EntityPlayer player, INutrient nutrient, float amount) {
        INutrientManager nutrientManager = NutritionUtilImpl.getNutrientManager(player);
        nutrientManager.add((Nutrient)nutrient, amount);
    }

    public static void resetNutrient(EntityPlayer player, INutrient nutrient) {
        INutrientManager nutrientManager = NutritionUtilImpl.getNutrientManager(player);
        nutrientManager.reset((Nutrient)nutrient);
    }

    private static INutrientManager getNutrientManager(EntityPlayer player) {
        INutrientManager nutrientManager;
        if (!player.func_130014_f_().field_72995_K) {
            nutrientManager = (INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null);
            if (nutrientManager == null) {
                throw new IllegalStateException("Player \"" + player.func_70005_c_() + "\" doesn't have the capability!");
            }
        } else {
            nutrientManager = ClientProxy.localNutrition;
            if (nutrientManager == null) {
                throw new IllegalStateException("ClientProxy.localNutrition is null");
            }
        }
        return nutrientManager;
    }
}

