/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.command;

import ca.wescook.nutrition.api.NutritionUtil;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.nutrients.NutritionUtilImpl;
import ca.wescook.nutrition.utility.DataUpdater;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandEditNutrition
extends CommandBase {
    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "nutrition-food";
    }

    public String func_71518_a(ICommandSender sender) {
        return this.func_71517_b() + " [add|remove <nutrient> [...]]";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandEditNutrition.func_71530_a((String[])args, (String[])new String[]{"add", "remove"});
        }
        if (args.length == 2) {
            return CommandEditNutrition.func_175762_a((String[])args, (Collection)NutrientList.get().stream().map(nutrient -> nutrient.name).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (!NutritionUtil.isValidFood(heldItem)) {
                throw new CommandException("Holding item is not food!", new Object[0]);
            }
            switch (args.length) {
                case 0: {
                    sender.func_145747_a((ITextComponent)new TextComponentString(CommandEditNutrition.createInfo(heldItem, player)));
                    break;
                }
                case 2: 
                case 3: {
                    String type;
                    switch (type = args[0]) {
                        case "add": {
                            Nutrient nutrient = CommandEditNutrition.getNutrient(args);
                            if (args.length == 2) {
                                if (nutrient.getScaledItemStack(heldItem) != null) {
                                    throw new CommandException(args[1] + " is already added to " + heldItem.func_77973_b().getRegistryName() + "!", new Object[0]);
                                }
                                nutrient.addScaledItemStack(new Nutrient.ScaledItemStack(heldItem, 1.0f));
                                DataUpdater.add(nutrient, new Nutrient.ScaledItemStack(heldItem, 1.0f));
                                sender.func_145747_a((ITextComponent)new TextComponentString(args[1] + " is added to " + heldItem.func_77973_b().getRegistryName()));
                                break;
                            }
                            float scale = (float)CommandEditNutrition.func_180526_a((String)args[2], (double)0.0);
                            Nutrient.ScaledItemStack scaledItemStack = new Nutrient.ScaledItemStack(heldItem, scale);
                            if (nutrient.addOrReplaceScaledItemStack(scaledItemStack)) {
                                DataUpdater.add(nutrient, scaledItemStack);
                                break;
                            }
                            DataUpdater.edit(nutrient, scaledItemStack);
                            break;
                        }
                        case "remove": {
                            Nutrient nutrient = CommandEditNutrition.getNutrient(args);
                            Nutrient.ScaledItemStack removed = nutrient.removeScaledItemStack(heldItem);
                            if (removed == null) {
                                throw new CommandException(heldItem.func_77973_b().getRegistryName() + "doesn't have " + args[1], new Object[0]);
                            }
                            DataUpdater.remove(nutrient, removed);
                            sender.func_145747_a((ITextComponent)new TextComponentString(args[1] + " is removed from " + heldItem.func_77973_b().getRegistryName()));
                        }
                    }
                    break;
                }
                default: {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
            }
        }
    }

    @NotNull
    private static Nutrient getNutrient(String[] args) throws CommandException {
        Nutrient nutrient;
        if (args[1].isEmpty()) {
            switch (args[0]) {
                case "add": {
                    throw new WrongUsageException("add <nutrient> [<scale>]", new Object[0]);
                }
                case "remove": {
                    throw new WrongUsageException("remove <nutrient>", new Object[0]);
                }
            }
        }
        if ((nutrient = NutrientList.getByName(args[1])) == null) {
            throw new CommandException("Unknown nutrient:" + args[1], new Object[0]);
        }
        return nutrient;
    }

    private static String createInfo(ItemStack itemStack, EntityPlayer player) {
        ArrayListMultimap nutritionValue2Nutrient = ArrayListMultimap.create();
        for (Map.Entry<Nutrient, Float> entry : NutritionUtilImpl.calculateNutrition(itemStack, player).entrySet()) {
            nutritionValue2Nutrient.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Float key : nutritionValue2Nutrient.keySet()) {
            list.add(CommandEditNutrition.createTooltip(key.floatValue(), nutritionValue2Nutrient.get((Object)key)));
        }
        if (list.isEmpty()) {
            return itemStack.func_77973_b().getRegistryName() + " has no nutrients";
        }
        return StringUtils.join(list, (String)", ");
    }

    private static String createTooltip(float nutritionValue, Collection<Nutrient> nutrients) {
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (Nutrient nutrient : nutrients) {
            if (!nutrient.visible) continue;
            stringJoiner.add(I18n.func_135052_a((String)("nutrient.nutrition:" + nutrient.name), (Object[])new Object[0]));
        }
        String nutrientString = stringJoiner.toString();
        return I18n.func_135052_a((String)"tooltip.nutrition:nutrients", (Object[])new Object[0]) + " " + TextFormatting.DARK_GREEN + nutrientString + TextFormatting.DARK_AQUA + " (" + String.format("%.1f", Float.valueOf(nutritionValue)) + "%)";
    }
}

