/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.api;

import ca.wescook.nutrition.api.INutrient;
import ca.wescook.nutrition.api.INutritionFoodAdapter;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.nutrients.NutritionAdapterManager;
import ca.wescook.nutrition.nutrients.NutritionUtilImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class NutritionUtil {
    public static Map<? extends INutrient, Float> calculateNutrition(ItemStack itemStack, @Nullable EntityPlayer player) {
        return NutritionUtilImpl.calculateNutrition(itemStack, player);
    }

    public static boolean isValidFood(ItemStack itemStack) {
        return NutritionUtilImpl.isValidFood(itemStack);
    }

    public static boolean addNutrientsToPlayer(EntityPlayer player, ItemStack itemStack) {
        return NutritionUtilImpl.addNutrientsToPlayer(player, itemStack);
    }

    public static List<? extends INutrient> getNutrients() {
        return Collections.unmodifiableList(NutrientList.get());
    }

    @Nullable
    public static INutrient getNutrientByName(String name) {
        return NutrientList.getByName(name);
    }

    public static float getNutrient(EntityPlayer player, INutrient nutrient) {
        return NutritionUtilImpl.getNutrient(player, nutrient);
    }

    public static void setNutrient(EntityPlayer player, INutrient nutrient, float value) {
        NutritionUtilImpl.setNutrient(player, nutrient, value);
    }

    public static void addNutrient(EntityPlayer player, INutrient nutrient, float amount) {
        NutritionUtilImpl.addNutrient(player, nutrient, amount);
    }

    public static void resetNutrient(EntityPlayer player, INutrient nutrient) {
        NutritionUtilImpl.resetNutrient(player, nutrient);
    }

    public static void register(INutritionFoodAdapter adapter) {
        NutritionAdapterManager.register(adapter);
    }
}

