/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api;

import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public interface IExpressionNode {
    default public IExpressionNode inline() {
        return this;
    }

    public String evaluateAsString();

    @FunctionalInterface
    public static interface INodeString
    extends INodeObject<String> {
        @Override
        default public Class<String> getType() {
            return String.class;
        }
    }

    public static interface INodeObject<T>
    extends IExpressionNode,
    Supplier<T> {
        public T evaluate();

        public Class<T> getType();

        @Override
        default public INodeObject<T> inline() {
            return this;
        }

        @Override
        default public String evaluateAsString() {
            return this.evaluate().toString();
        }

        @Override
        default public T get() {
            return this.evaluate();
        }

        public static <T> INodeObject<T> create(final Class<T> clazz, final Supplier<T> supplier) {
            return new INodeObject<T>(){

                @Override
                public T evaluate() {
                    return supplier.get();
                }

                @Override
                public Class<T> getType() {
                    return clazz;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface INodeBoolean
    extends IExpressionNode,
    BooleanSupplier {
        public boolean evaluate();

        @Override
        default public INodeBoolean inline() {
            return this;
        }

        @Override
        default public String evaluateAsString() {
            return Boolean.toString(this.evaluate());
        }

        @Override
        default public boolean getAsBoolean() {
            return this.evaluate();
        }
    }

    @FunctionalInterface
    public static interface INodeLong
    extends IExpressionNode,
    LongSupplier,
    IntSupplier {
        public long evaluate();

        @Override
        default public INodeLong inline() {
            return this;
        }

        @Override
        default public String evaluateAsString() {
            return Long.toString(this.evaluate());
        }

        @Override
        default public long getAsLong() {
            return this.evaluate();
        }

        @Override
        default public int getAsInt() {
            return (int)this.evaluate();
        }
    }

    @FunctionalInterface
    public static interface INodeDouble
    extends IExpressionNode,
    DoubleSupplier {
        public double evaluate();

        @Override
        default public INodeDouble inline() {
            return this;
        }

        @Override
        default public String evaluateAsString() {
            return Double.toString(this.evaluate());
        }

        @Override
        default public double getAsDouble() {
            return this.evaluate();
        }
    }
}

