/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.render;

import alexiil.mc.mod.load.CLSLog;
import alexiil.mc.mod.load.CustomLoadingScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class TextureManagerCLS
extends TextureManager {
    private final Map<ResourceLocation, Long> textures = new HashMap<ResourceLocation, Long>();
    private Long currentTime = System.currentTimeMillis();

    public TextureManagerCLS(IResourceManager resourceManager) {
        super(resourceManager);
    }

    private void onTextureAccess(ResourceLocation resource) {
        this.textures.put(resource, this.currentTime);
    }

    public void func_110577_a(ResourceLocation resource) {
        super.func_110577_a(resource);
        this.onTextureAccess(resource);
    }

    public ITextureObject func_110581_b(ResourceLocation resource) {
        ITextureObject obj = super.func_110581_b(resource);
        if (obj != null) {
            this.onTextureAccess(resource);
        }
        return obj;
    }

    public void func_147645_c(ResourceLocation textureLocation) {
        super.func_147645_c(textureLocation);
        this.textures.remove(textureLocation);
    }

    public boolean func_110579_a(ResourceLocation textureLocation, ITextureObject textureObj) {
        this.onTextureAccess(textureLocation);
        return super.func_110579_a(textureLocation, textureObj);
    }

    public boolean func_110580_a(ResourceLocation textureLocation, ITickableTextureObject textureObj) {
        this.onTextureAccess(textureLocation);
        return super.func_110580_a(textureLocation, textureObj);
    }

    public void deleteAll() {
        for (ResourceLocation location : this.textures.keySet().toArray(new ResourceLocation[0])) {
            this.func_147645_c(location);
        }
    }

    public void onFrame() {
        if (CustomLoadingScreen.textureClearInterval == 0) {
            return;
        }
        Long last = this.currentTime;
        long next = System.currentTimeMillis();
        if (last + 1000L < next) {
            return;
        }
        this.currentTime = next;
        long minTime = this.currentTime - (long)(CustomLoadingScreen.textureClearInterval * 1000);
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, Long> entry : this.textures.entrySet()) {
            if (entry.getValue() >= minTime) continue;
            toRemove.add(entry.getKey());
        }
        for (ResourceLocation tex : toRemove) {
            if (CustomLoadingScreen.debugResourceLoading) {
                CLSLog.info("[debug] Automatically deleting texture " + tex);
            }
            this.func_147645_c(tex);
        }
    }
}

