/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.render;

import alexiil.mc.mod.load.ClsManager;
import alexiil.mc.mod.load.baked.BakedAction;
import alexiil.mc.mod.load.baked.BakedConfig;
import alexiil.mc.mod.load.baked.BakedFactory;
import alexiil.mc.mod.load.baked.BakedRenderingPart;
import alexiil.mc.mod.load.baked.BakedTickable;
import alexiil.mc.mod.load.baked.BakedVariable;
import alexiil.mc.mod.load.render.FontRendererSeparate;
import alexiil.mc.mod.load.render.TextureAnimator;
import alexiil.mc.mod.load.render.TextureManagerCLS;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.opengl.SharedDrawable;

public class MinecraftDisplayerRenderer {
    private static final ResourceLocation FONT_LOCATION = new ResourceLocation("textures/font/ascii.png");
    public final TextureAnimator animator;
    private final BakedVariable[] variables;
    private final BakedRenderingPart[] renderingParts;
    private final BakedAction[] actions;
    private final BakedFactory[] factories;
    private long lastTime;
    private Minecraft mc;
    private final Map<String, FontRenderer> fontRenderers = Maps.newHashMap();
    private final FontRendererSeparate _font_render_instance;
    public TextureManagerCLS textureManager;
    private boolean first = true;
    private SharedDrawable drawable;

    public MinecraftDisplayerRenderer(BakedConfig config) {
        this.animator = new TextureAnimator(config);
        this.mc = Minecraft.func_71410_x();
        this.textureManager = new TextureManagerCLS(this.mc.func_110442_L());
        this._font_render_instance = new FontRendererSeparate(this.mc.field_71474_y, FONT_LOCATION, this.textureManager, false);
        this.mc.func_110436_a();
        this.textureManager.func_110549_a(this.mc.func_110442_L());
        this._font_render_instance.func_110549_a(this.mc.func_110442_L());
        this.variables = config.variables;
        this.renderingParts = config.renderingParts;
        this.actions = config.actions;
        this.factories = config.factories;
        this.lastTime = System.currentTimeMillis();
        config.preLoad(this);
    }

    public void render() {
        if (GLContext.getCapabilities().GL_KHR_debug) {
            KHRDebug.glPushDebugGroup((int)33354, (int)10, (CharSequence)"CLS_Render");
        }
        ClsManager.Resolution resolution = ClsManager.RESOLUTION;
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)resolution.getWidth(), (double)resolution.getHeight(), (double)0.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)6145);
        GL11.glEnable((int)3553);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16640);
        GL11.glEnable((int)6406);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3042);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.animator.tick();
        for (BakedVariable bakedVariable : this.variables) {
            bakedVariable.tick(this);
        }
        for (BakedTickable bakedTickable : this.renderingParts) {
            if (bakedTickable == null) continue;
            if (GLContext.getCapabilities().GL_KHR_debug) {
                KHRDebug.glPushDebugGroup((int)33354, (int)10, (CharSequence)("" + bakedTickable.getOrigin()));
            }
            ((BakedRenderingPart)bakedTickable).tick(this);
            if (!GLContext.getCapabilities().GL_KHR_debug) continue;
            KHRDebug.glPopDebugGroup();
        }
        for (BakedTickable bakedTickable : this.factories) {
            ((BakedFactory)bakedTickable).tick(this);
        }
        for (BakedTickable bakedTickable : this.actions) {
            ((BakedAction)bakedTickable).tick(this);
        }
        GL11.glEnable((int)3042);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)0, (int)0);
        GL11.glEnable((int)6406);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.textureManager.onFrame();
        if (GLContext.getCapabilities().GL_KHR_debug) {
            KHRDebug.glPopDebugGroup();
        }
    }

    public FontRenderer fontRenderer(String fontTexture) {
        if ("missingno".equals(fontTexture)) {
            return this._font_render_instance;
        }
        if (this.fontRenderers.containsKey(fontTexture)) {
            return this.fontRenderers.get(fontTexture);
        }
        FontRendererSeparate font = new FontRendererSeparate(this.mc.field_71474_y, new ResourceLocation(fontTexture), this.textureManager, false);
        font.func_110549_a(this.mc.func_110442_L());
        this.fontRenderers.put(fontTexture, font);
        return font;
    }

    public void close() {
        this._font_render_instance.destroy();
        this.animator.close();
        this.textureManager.deleteAll();
    }
}

