/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json.subtypes;

import alexiil.mc.mod.load.baked.BakedRender;
import alexiil.mc.mod.load.baked.render.BakedAnimatedRender;
import alexiil.mc.mod.load.baked.render.BakedArea;
import alexiil.mc.mod.load.baked.render.BakedImageRender;
import alexiil.mc.mod.load.json.Area;
import alexiil.mc.mod.load.json.subtypes.JsonRenderPositioned;
import alexiil.mc.mod.load.render.TextureAnimator;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.FunctionContext;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.GenericExpressionCompiler;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeConstantDouble;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeVariableDouble;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;

public class JsonRenderImage
extends JsonRenderPositioned {
    public final Area texture;
    public final String frame;
    public final boolean loop;

    public JsonRenderImage(JsonRenderImage parent, JsonObject json, JsonDeserializationContext context) {
        super(parent, json, context);
        this.texture = JsonRenderImage.consolidateArea(json, "texture", context, parent == null ? null : parent.texture);
        this.frame = JsonRenderImage.overrideObject(json, "frame", context, String.class, parent == null ? null : parent.frame, "time");
        this.loop = JsonRenderImage.overrideObject(json, "loop", context, Boolean.class, parent == null ? null : Boolean.valueOf(parent.loop), true);
    }

    @Override
    protected BakedRender actuallyBake(FunctionContext context) throws InvalidExpressionException {
        BakedArea tex;
        NodeVariableDouble varWidth = context.putVariableDouble("elem_width");
        NodeVariableDouble varHeight = context.putVariableDouble("elem_height");
        IExpressionNode.INodeLong _colour = GenericExpressionCompiler.compileExpressionLong(this.colour, context);
        BakedArea pos = (this.position == null ? new Area("0", "0", "screen_width", "screen_height") : this.position).bake(context);
        if (this.texture == null) {
            NodeConstantDouble zero = NodeConstantDouble.ZERO;
            NodeConstantDouble one = NodeConstantDouble.ONE;
            tex = new BakedArea(zero, zero, one, one);
        } else {
            tex = this.texture.bake(context);
        }
        if (TextureAnimator.isAnimated(this.image)) {
            IExpressionNode.INodeDouble _frame = GenericExpressionCompiler.compileExpressionDouble(this.frame, context);
            return new BakedAnimatedRender(varWidth, varHeight, this.image, pos, tex, _frame, this.loop);
        }
        return new BakedImageRender(varWidth, varHeight, this.image, pos, tex);
    }
}

