/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json;

import alexiil.mc.mod.load.baked.BakedRender;
import alexiil.mc.mod.load.baked.BakedRenderingPart;
import alexiil.mc.mod.load.baked.insn.BakedInsn;
import alexiil.mc.mod.load.json.JsonConfigurable;
import alexiil.mc.mod.load.json.JsonInsn;
import alexiil.mc.mod.load.json.JsonRender;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.FunctionContext;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.GenericExpressionCompiler;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeConstantBoolean;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;

public class JsonRenderingPart
extends JsonConfigurable<JsonRenderingPart, BakedRenderingPart> {
    public final JsonRender image;
    public final JsonInsn[] instructions;
    public final String shouldRender;

    public JsonRenderingPart(JsonRender image, JsonInsn[] instructions, String shouldRender) {
        this.image = image;
        this.instructions = instructions;
        this.shouldRender = shouldRender;
    }

    public JsonRenderingPart(JsonRenderingPart parent, JsonObject json, JsonDeserializationContext context) {
        this.image = json.has("image") ? (JsonRender)context.deserialize(json.get("image"), JsonRender.class) : (parent == null ? null : parent.image);
        JsonInsn[] insns = json.has("instructions") ? (JsonInsn[])context.deserialize(json.get("instructions"), JsonInsn[].class) : new JsonInsn[]{};
        this.instructions = JsonRenderingPart.consolidateArray(parent == null ? null : parent.instructions, insns);
        this.shouldRender = JsonRenderingPart.consolidateFunction(json, "should_render", context, parent == null ? null : parent.shouldRender, "true");
    }

    @Override
    public void setLocation(ResourceLocation location) {
        super.setLocation(location);
        location = this.resourceLocation;
        this.image.setLocation(location);
        for (JsonInsn insn : this.instructions) {
            insn.setLocation(location);
        }
    }

    @Override
    protected BakedRenderingPart actuallyBake(FunctionContext context) throws InvalidExpressionException {
        ArrayList<BakedInsn> args = new ArrayList<BakedInsn>();
        JsonRender element = this.image;
        context = new FunctionContext(context);
        BakedRender actualRender = (BakedRender)element.bake(context);
        args.addAll(element.bakeInstructions(context));
        if (this.instructions != null) {
            for (JsonInsn insn : this.instructions) {
                args.add((BakedInsn)insn.bake(context));
            }
        }
        BakedInsn[] instructions = args.toArray(new BakedInsn[args.size()]);
        IExpressionNode.INodeBoolean shouldRenderFunc = this.shouldRender == null ? NodeConstantBoolean.TRUE : GenericExpressionCompiler.compileExpressionBoolean(this.shouldRender, context);
        return new BakedRenderingPart(instructions, actualRender, shouldRenderFunc);
    }

    public JsonRender getImageRender() {
        return this.image;
    }
}

