/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.frame;

import alexiil.mc.mod.load.progress.SingleProgressBarTracker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class LoadingFrame
extends JFrame {
    private final JProgressBar jprogress;

    public static LoadingFrame openWindow() {
        String clsName = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(clsName);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            LoadingFrame frame = new LoadingFrame();
            frame.setBounds(LoadingFrame.getWindowBounds(frame));
            frame.setAlwaysOnTop(true);
            frame.setVisible(true);
            return frame;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Rectangle getWindowBounds(LoadingFrame frame) {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle bounds = frame.getBounds();
        return new Rectangle((size.width - bounds.width) / 2, (size.height - bounds.height) / 2, bounds.width, bounds.height);
    }

    public LoadingFrame() {
        this.setTitle("Minecraft Loading");
        this.setDefaultCloseOperation(0);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(contentPane);
        this.jprogress = new JProgressBar(0, 100);
        contentPane.add((Component)this.jprogress, "Center");
        this.pack();
        this.setSize(400, this.getHeight());
    }

    public void setProgress() {
        boolean isInReload;
        int progress;
        String subStatus;
        String status;
        try (SingleProgressBarTracker.LockUnlocker u = SingleProgressBarTracker.lockUpdate();){
            status = SingleProgressBarTracker.getStatusText();
            subStatus = SingleProgressBarTracker.getSubStatus();
            progress = SingleProgressBarTracker.getProgress();
            isInReload = SingleProgressBarTracker.isInReload();
        }
        this.setTitle(isInReload ? status : status + " - " + subStatus);
        double p = (double)progress / 1048576.0;
        this.jprogress.setValue((int)(p * 100.0));
        this.jprogress.repaint();
    }
}

