/*
 * Decompiled with CFR 0.152.
 */
package com.Zeno410Utils;

import com.Zeno410Utils.Acceptor;
import com.Zeno410Utils.Trackable;
import com.Zeno410Utils.Trackers;

public interface Mutable<Type>
extends Trackable<Type> {
    public void set(Type var1);

    public void set(Mutable<Type> var1);

    public Type value();

    public static class Concrete<CType>
    implements Mutable<CType> {
        private CType type;
        private Trackers<CType> trackers = new Trackers();

        public Concrete(CType initial) {
            this.type = initial;
        }

        @Override
        public void set(CType newValue) {
            this.type = newValue;
            this.trackers.update(this.type);
        }

        @Override
        public void set(Mutable<CType> toCopy) {
            this.set(toCopy.value());
        }

        @Override
        public CType value() {
            return this.type;
        }

        @Override
        public void informOnChange(Acceptor<CType> target) {
            this.trackers.informOnChange(target);
        }

        @Override
        public void stopInforming(Acceptor<CType> target) {
            this.trackers.stopInforming(target);
        }
    }
}

