/*
 * Decompiled with CFR 0.152.
 */
package com.Zeno410Utils;

import com.Zeno410Utils.Accessor;
import java.lang.reflect.Field;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.structure.MapGenVillage;

public class ChunkGeneratorExtractor {
    private AccessChunkProviderServer accessChunkProviderServer = new AccessChunkProviderServer();
    private Accessor<ChunkProviderServer, IChunkProvider> providerFromChunkServer = new Accessor("field_73246_d");
    private Accessor<ChunkGeneratorOverworld, MapGenVillage> villageGeneratorFromVillage = new Accessor("field_73224_v");

    public IChunkProvider extractFrom(WorldServer world) {
        ChunkProviderServer server = this.accessChunkProviderServer.chunkProviderServer(world);
        IChunkProvider provider = this.providerFromChunkServer.get(server);
        if (!(provider instanceof ChunkGeneratorOverworld)) {
            // empty if block
        }
        return provider;
    }

    public void impose(WorldServer world, MapGenVillage mapGen) {
        IChunkProvider provider = this.extractFrom(world);
        if (provider instanceof ChunkGeneratorOverworld) {
            this.villageGeneratorFromVillage.setField((ChunkGeneratorOverworld)provider, mapGen);
        }
    }

    static class AccessChunkProviderServer {
        Field iChunkProviderServerField;

        AccessChunkProviderServer() {
            try {
                this.setIChunkProviderField();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private void setIChunkProviderField() throws IllegalAccessException {
            Field[] fields = WorldServer.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().contains("field_73059_b")) continue;
                this.iChunkProviderServerField = fields[i];
                this.iChunkProviderServerField.setAccessible(true);
            }
        }

        public ChunkProviderServer chunkProviderServer(WorldServer world) {
            try {
                return (ChunkProviderServer)this.iChunkProviderServerField.get(world);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void setIChunkProvider(WorldServer world, ChunkProviderServer chunkProvider) {
            try {
                this.iChunkProviderServerField.set(world, chunkProvider);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

