/*
 * Decompiled with CFR 0.152.
 */
package climateControl.customGenLayer;

import climateControl.api.ClimateControlSettings;
import climateControl.api.IslandClimateMaker;
import climateControl.genLayerPack.GenLayerPack;
import com.Zeno410Utils.IntRandomizer;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;

public class GenLayerBandedClimate
extends GenLayerPack
implements IslandClimateMaker {
    private final int bandWidth;
    private final int[] bandClimate = new int[6];
    private final int offset;
    private final boolean frozenIcecaps;
    private final boolean separateLandmasses;

    public GenLayerBandedClimate(long par1, GenLayer par3GenLayer, ClimateControlSettings settings, int multiplier) {
        super(par1);
        this.field_75909_a = par3GenLayer;
        this.offset = settings.bandedClimateOffset.value() * multiplier - multiplier / 2;
        this.bandWidth = settings.bandedClimateWidth.value() * multiplier;
        this.bandClimate[0] = 2;
        this.bandClimate[1] = 1;
        this.bandClimate[2] = 2;
        this.bandClimate[3] = 3;
        this.bandClimate[4] = 4;
        this.bandClimate[5] = 3;
        this.frozenIcecaps = settings.frozenIcecaps.value();
        this.separateLandmasses = settings.separateLandmasses.value();
    }

    @Override
    public int[] func_75904_a(int par1, int par2, int par3, int par4) {
        int[] aint = this.field_75909_a.func_75904_a(par1, par2, par3, par4);
        int[] aint1 = new int[par3 * par4];
        for (int i1 = 0; i1 < par4; ++i1) {
            for (int j1 = 0; j1 < par3; ++j1) {
                int latitude = par2 + i1 + this.offset;
                int band = 0;
                if (latitude >= 0) {
                    band = latitude / this.bandWidth;
                    band %= 6;
                } else {
                    band = (latitude - this.bandWidth + 1) / this.bandWidth;
                    if ((band %= 6) < -5) {
                        throw new RuntimeException("" + latitude + " " + band);
                    }
                    if (band < 0) {
                        band += 6;
                    }
                }
                if (aint[j1 + i1 * par3] == 0) {
                    if (this.frozenIcecaps && this.bandClimate[band] == 4) {
                        aint1[j1 + i1 * par3] = Biome.func_185362_a((Biome)Biomes.field_76776_l);
                        continue;
                    }
                    aint1[j1 + i1 * par3] = 0;
                    continue;
                }
                aint1[j1 + i1 * par3] = this.bandClimate[band];
                if (!this.separateLandmasses) continue;
                int n = j1 + i1 * par3;
                aint1[n] = aint1[n] + aint[j1 + i1 * par3] * 4;
            }
        }
        return aint1;
    }

    @Override
    public int climate(int x, int latitude, IntRandomizer randomizer) {
        int band = 0;
        if ((latitude += this.offset) >= 0) {
            band = latitude / this.bandWidth;
            band %= 6;
        } else {
            band = (latitude - this.bandWidth + 1) / this.bandWidth;
            if ((band %= 6) < -5) {
                throw new RuntimeException("" + latitude + " " + band);
            }
            if (band < 0) {
                band += 6;
            }
        }
        return this.bandClimate[band];
    }
}

