/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import climateControl.api.BiomeSettings;
import climateControl.api.Climate;
import climateControl.api.ClimateControlRules;
import climateControl.api.ClimateDistribution;
import climateControl.biomeSettings.BiomeReplacer;
import com.Zeno410Utils.Mutable;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class VanillaBiomeSettings
extends BiomeSettings {
    public static int birchForestDefault = 10;
    public static int coldTaigaDefault = 10;
    public static int desertDefault = 30;
    public static int extremeHillsDefault = 20;
    public static int forestDefault = 20;
    public static int icePlainsDefault = 30;
    public static int jungleDefault = 5;
    public static int megaTaigaDefault = 5;
    public static int mesaPlateauDefault = 1;
    public static int mesaPlateau_FDefault = 4;
    public static int plainsDefault = 30;
    public static int roofedForestDefault = 7;
    public static int savannaDefault = 10;
    public static int swamplandDefault = 10;
    public static int taigaDefault = 20;
    public static final String birchForestName = "Birch Forest";
    public static final String coldTaigaName = "Cold Taiga";
    public static final String desertName = "Desert";
    public static final String extremeHillsName = "Extreme Hills";
    public static final String forestName = "Forest";
    public static final String icePlainsName = "Ice Plains";
    public static final String iceMountainsName = "Ice Mountains";
    public static final String jungleName = "Jungle";
    public static final String megaTaigaName = "Mega Taiga";
    public static final String mesaPlateauName = "Mesa Plateau";
    public static final String mesaPlateau_FName = "Mesa Plateau F";
    public static final String plainsName = "Plains";
    public static final String roofedForestName = "Roofed Forest";
    public static final String savannaName = "Savanna";
    public static final String swamplandName = "Swampland";
    public static final String taigaName = "Taiga (snowless)";
    public static final String biomeCategory = "VanillaBiome";
    BiomeSettings.Element birchForest;
    BiomeSettings.Element coldTaiga;
    BiomeSettings.Element desert;
    BiomeSettings.Element extremeHills;
    BiomeSettings.Element forest;
    BiomeSettings.Element icePlains;
    BiomeSettings.Element jungle;
    BiomeSettings.Element megaTaiga;
    BiomeSettings.Element mesaPlateau;
    BiomeSettings.Element mesaPlateau_F;
    BiomeSettings.Element plains;
    BiomeSettings.Element roofedForest;
    BiomeSettings.Element savanna;
    BiomeSettings.Element swampland;
    BiomeSettings.Element taiga;
    BiomeSettings.Element iceMountains;
    BiomeSettings.ID mushroomIsland;
    BiomeSettings.ID desertHills;
    BiomeSettings.ID forestHills;
    BiomeSettings.ID taigaHills;
    BiomeSettings.ID extremeHillsEdge;
    BiomeSettings.ID jungleHills;
    BiomeSettings.ID jungleEdge;
    BiomeSettings.ID birchForestHills;
    BiomeSettings.ID coldTaigaHills;
    BiomeSettings.ID megaTaigaHills;
    BiomeSettings.ID extremeHillsPlus;
    BiomeSettings.ID savannaPlateau;
    BiomeSettings.ID mesa;
    BiomeSettings.ID sunflowerPlains;
    BiomeSettings.ID desertM;
    BiomeSettings.ID extremeHillsM;
    BiomeSettings.ID flowerForest;
    BiomeSettings.ID taigaM;
    BiomeSettings.ID swamplandM;
    BiomeSettings.ID icePlainsSpikes;
    BiomeSettings.ID jungleM;
    BiomeSettings.ID birchForestM;
    BiomeSettings.ID birchForestHillsM;
    BiomeSettings.ID roofedForestM;
    BiomeSettings.ID coldTaigaM;
    BiomeSettings.ID megaSpruceTaiga;
    BiomeSettings.ID extremeHillsPlusM;
    BiomeSettings.ID savannaM;
    BiomeSettings.ID savannaPlateauM;
    BiomeSettings.ID bryceMesa;
    BiomeSettings.ID mesaPlateauM;
    BiomeSettings.ID mesaPlateau_FM;
    static final String biomesOnName = "VanillaBiomesOn";
    public final Mutable<Boolean> biomesFromConfig;

    public VanillaBiomeSettings() {
        super(biomeCategory);
        this.birchForest = new BiomeSettings.Element((BiomeSettings)this, birchForestName, 27, 10, Climate.WARM.name);
        this.coldTaiga = new BiomeSettings.Element((BiomeSettings)this, coldTaigaName, 10, false, Climate.SNOWY.name, "minecraft:taiga_cold", "minecraft:cold_beach");
        this.desert = new BiomeSettings.Element((BiomeSettings)this, desertName, 2, 30, true, Climate.HOT.name);
        this.extremeHills = new BiomeSettings.Element((BiomeSettings)this, extremeHillsName, 20, false, ClimateDistribution.MEDIUM.name(), "minecraft:extreme_hills", "minecraft:stone_beach");
        this.forest = new BiomeSettings.Element((BiomeSettings)this, forestName, 4, 20, ClimateDistribution.MEDIUM.name());
        this.icePlains = new BiomeSettings.Element((BiomeSettings)this, icePlainsName, 30, false, Climate.SNOWY.name, "minecraft:ice_flats", "minecraft:cold_beach");
        this.jungle = new BiomeSettings.Element((BiomeSettings)this, jungleName, 21, 5, Climate.HOT.name);
        this.megaTaiga = new BiomeSettings.Element((BiomeSettings)this, megaTaigaName, 5, false, Climate.COOL.name, "minecraft:redwood_taiga", "minecraft:beaches");
        this.mesaPlateau = new BiomeSettings.Element((BiomeSettings)this, mesaPlateauName, 39, 1, Climate.HOT.name);
        this.mesaPlateau_F = new BiomeSettings.Element((BiomeSettings)this, mesaPlateau_FName, 38, 4, Climate.HOT.name);
        this.plains = new BiomeSettings.Element((BiomeSettings)this, plainsName, 1, 30, true, ClimateDistribution.PLAINS.name());
        this.roofedForest = new BiomeSettings.Element((BiomeSettings)this, roofedForestName, 29, 10, Climate.COOL.name);
        this.savanna = new BiomeSettings.Element((BiomeSettings)this, savannaName, 35, 20, true, Climate.HOT.name);
        this.swampland = new BiomeSettings.Element((BiomeSettings)this, swamplandName, 10, false, Climate.WARM.name, "minecraft:swampland", "minecraft:swampland");
        this.taiga = new BiomeSettings.Element((BiomeSettings)this, taigaName, 10, false, Climate.COOL.name, "minecraft:taiga", "minecraft:beaches");
        this.iceMountains = new BiomeSettings.Element((BiomeSettings)this, iceMountainsName, 0, false, Climate.SNOWY.name, "minecraft:ice_mountains", "minecraft:cold_beach");
        this.mushroomIsland = new BiomeSettings.ID((BiomeSettings)this, "Mushroom Island", "minecraft:mushroom_island", "minecraft:mushroom_island_shore");
        this.desertHills = new BiomeSettings.ID((BiomeSettings)this, "Desert Hills", 17);
        this.forestHills = new BiomeSettings.ID((BiomeSettings)this, "Forest Hills", 18);
        this.taigaHills = new BiomeSettings.ID((BiomeSettings)this, "Taiga Hills", 19);
        this.extremeHillsEdge = new BiomeSettings.ID((BiomeSettings)this, "Extreme Hills Edge", "minecraft:smaller_extreme_hills", "minecraft:stone_beach");
        this.jungleHills = new BiomeSettings.ID((BiomeSettings)this, "Jungle Hills", 22);
        this.jungleEdge = new BiomeSettings.ID((BiomeSettings)this, "Jungle Edge", 23);
        this.birchForestHills = new BiomeSettings.ID((BiomeSettings)this, "Birch Forest Hills", 28);
        this.coldTaigaHills = new BiomeSettings.ID((BiomeSettings)this, "Cold Taiga Hills", "minecraft:taiga_cold_hills", "minecraft:cold_beach");
        this.megaTaigaHills = new BiomeSettings.ID((BiomeSettings)this, "Mega Taiga Hills", 33);
        this.extremeHillsPlus = new BiomeSettings.ID((BiomeSettings)this, "Extreme Hills+", "minecraft:extreme_hills_with_trees", "minecraft:stone_beach");
        this.savannaPlateau = new BiomeSettings.ID((BiomeSettings)this, "Savanna Plateau", 36);
        this.mesa = new BiomeSettings.ID((BiomeSettings)this, "Mesa", 37);
        this.sunflowerPlains = new BiomeSettings.ID((BiomeSettings)this, "Sunflower Plains", 129);
        this.desertM = this.M(this.desert);
        this.extremeHillsM = new BiomeSettings.ID((BiomeSettings)this, "Extreme Hills M", "minecraft:mutated_extreme_hills", "minecraft:stone_beach");
        this.flowerForest = this.M(this.forest, "Flower Forest");
        this.taigaM = this.M(this.taiga);
        this.swamplandM = new BiomeSettings.ID((BiomeSettings)this, "Swamp M", "minecraft:mutated_swampland", "minecraft:mutated_swampland");
        this.icePlainsSpikes = new BiomeSettings.ID((BiomeSettings)this, "Ice Plains Spikes", "minecraft:mutated_ice_flats", "minecraft:cold_beach");
        this.jungleM = this.M(this.jungle);
        this.birchForestM = this.M(this.birchForest);
        this.birchForestHillsM = this.M(this.birchForestHills);
        this.roofedForestM = this.M(this.roofedForest);
        this.coldTaigaM = new BiomeSettings.ID((BiomeSettings)this, "Cold Taiga M", "minecraft:mutated_taiga_cold", "minecraft:cold_beach");
        this.megaSpruceTaiga = this.M(this.megaTaiga, "Mega Spruce Taiga");
        this.extremeHillsPlusM = new BiomeSettings.ID((BiomeSettings)this, "Extreme Hills+ M", "minecraft:mutated_extreme_hills_with_trees", "minecraft:stone_beach");
        this.savannaM = this.M(this.savanna);
        this.savannaPlateauM = this.M(this.savannaPlateau);
        this.bryceMesa = this.M(this.mesa, "Mesa (Bryce)");
        this.mesaPlateauM = this.M(this.mesaPlateau);
        this.mesaPlateau_FM = this.M(this.mesaPlateau_F);
        this.biomesFromConfig = this.climateControlCategory.booleanSetting(biomesOnName, "", true);
        this.setNativeBiomeIDs();
        this.desert.setSubBiome(this.desertHills);
        this.forest.setSubBiome(this.forestHills);
        this.birchForest.setSubBiome(this.birchForestHills);
        this.roofedForest.setSubBiome(this.plains);
        this.taiga.setSubBiome(this.taigaHills);
        this.megaTaiga.setSubBiome(this.megaTaigaHills);
        this.coldTaiga.setSubBiome(this.coldTaigaHills);
        BiomeReplacer.Variable plainsSubBiomes = new BiomeReplacer.Variable();
        plainsSubBiomes.add(this.forestHills, 1);
        plainsSubBiomes.add(this.forest, 2);
        this.plains.setSubBiomeChooser(plainsSubBiomes);
        this.icePlains.setSubBiome(this.iceMountains);
        this.jungle.setSubBiome(this.jungleHills);
        this.extremeHills.setSubBiome(this.extremeHillsPlus);
        this.savanna.setSubBiome(this.savannaPlateau);
        this.mesaPlateau_F.setSubBiome(this.mesa);
    }

    private void setComplexSubbiomes() {
        BiomeReplacer.Variable subBiomes = new BiomeReplacer.Variable();
        subBiomes.add(this.forestHills, 2);
        subBiomes.add(this.plains, 1);
        subBiomes.add(this.extremeHills, 1);
        this.forest.setSubBiomeChooser(subBiomes);
        subBiomes = new BiomeReplacer.Variable();
        subBiomes.add(this.birchForestHills, 2);
        subBiomes.add(this.plains, 1);
        subBiomes.add(this.extremeHills, 1);
        this.birchForest.setSubBiomeChooser(subBiomes);
        subBiomes = new BiomeReplacer.Variable();
        subBiomes.add(this.forestHills, 2);
        subBiomes.add(this.forest, 2);
        subBiomes.add(this.birchForestHills, 1);
        subBiomes.add(this.birchForest, 1);
        subBiomes.add(this.extremeHills, 3);
        this.plains.setSubBiomeChooser(subBiomes);
        subBiomes = new BiomeReplacer.Variable();
        subBiomes.add(this.roofedForest, 1);
        subBiomes.add(this.extremeHills, 1);
        subBiomes.add(this.swampland, 3);
        this.swampland.setSubBiomeChooser(subBiomes);
        subBiomes = new BiomeReplacer.Variable();
        subBiomes.add(this.taigaHills, 3);
        subBiomes.add(this.plains, 1);
        subBiomes.add(this.extremeHills, 1);
        this.taiga.setSubBiomeChooser(subBiomes);
        subBiomes = new BiomeReplacer.Variable();
        subBiomes.add(this.megaTaigaHills, 3);
        subBiomes.add(this.plains, 1);
        subBiomes.add(this.extremeHills, 1);
        this.megaTaiga.setSubBiomeChooser(subBiomes);
        subBiomes = new BiomeReplacer.Variable();
        subBiomes.add(this.coldTaigaHills, 3);
        subBiomes.add(this.plains, 1);
        subBiomes.add(this.iceMountains, 1);
        this.coldTaiga.setSubBiomeChooser(subBiomes);
        subBiomes = new BiomeReplacer.Variable();
        subBiomes.add(this.coldTaigaHills, 1);
        subBiomes.add(this.icePlains, 1);
        subBiomes.add(this.iceMountains, 3);
        this.icePlains.setSubBiomeChooser(subBiomes);
        subBiomes = new BiomeReplacer.Variable();
        subBiomes.add(this.desertHills, 3);
        subBiomes.add(this.plains, 1);
        this.desert.setSubBiomeChooser(subBiomes);
        subBiomes = new BiomeReplacer.Variable();
        subBiomes.add(this.jungleHills, 3);
        subBiomes.add(this.jungleEdge, 1);
        this.jungle.setSubBiomeChooser(subBiomes);
    }

    @Override
    public void setNativeBiomeIDs(File configDirectory) {
        super.setNativeBiomeIDs(configDirectory);
    }

    @Override
    public void setRules(ClimateControlRules rules) {
        super.setRules(rules);
        this.setVillages(rules);
        if (rules.moreComplexSubbiomes()) {
            this.setComplexSubbiomes();
        }
    }

    @Override
    public boolean biomesAreActive() {
        return this.biomesFromConfig.value();
    }

    @Override
    public void onNewWorld() {
    }

    @Override
    public void stripIDsFrom(Configuration config) {
    }

    public void forceIceMountains() {
        if (this.iceMountains.biomeIncidences().value() < 10) {
            this.iceMountains.biomeIncidences().set(10);
        }
    }
}

