/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import climateControl.api.BiomeSettings;
import climateControl.api.Climate;
import com.Zeno410Utils.Mutable;
import java.io.File;

public class EnvironsSettings
extends BiomeSettings {
    public static final String biomeCategory = "EnvironsBiome";
    public final BiomeSettings.Element canyon;
    public final BiomeSettings.Element coldPineTaiga;
    public final BiomeSettings.Element coldPineTaigaM;
    public final BiomeSettings.Element dryOakForest;
    public final BiomeSettings.Element dryOakForestM;
    public final BiomeSettings.Element emeraldCliffs;
    public final BiomeSettings.Element endForest;
    public final BiomeSettings.Element floatingEndForest;
    public final BiomeSettings.Element extremeJungle;
    public final BiomeSettings.Element icyHills;
    public final BiomeSettings.Element kakadu;
    public final BiomeSettings.Element lushForest;
    public final BiomeSettings.Element mushroomRainforests;
    public final BiomeSettings.Element overgrownPlains;
    public final BiomeSettings.Element pineTaiga;
    public final BiomeSettings.Element pineTaigaM;
    public final BiomeSettings.Element roofedSwamp;
    public final BiomeSettings.Element sandstoneRanges;
    public final BiomeSettings.Element silkForest;
    public final BiomeSettings.Element stoneBasin;
    public final BiomeSettings.Element stoneHills;
    public final BiomeSettings.Element tallOakForest;
    public final BiomeSettings.Element tallOakForestM;
    public final BiomeSettings.Element tallOakWetlands;
    public final BiomeSettings.Element wastelandEroded;
    public final BiomeSettings.Element wastelandSpikes;
    static final String biomesOnName = "EnvironsBiomesOn";
    public final Mutable<Boolean> biomesFromConfig;
    static final String configName = "Environs";
    public final Mutable<Boolean> biomesInNewWorlds;

    public EnvironsSettings() {
        super(biomeCategory);
        this.canyon = new BiomeSettings.Element((BiomeSettings)this, "Canyon", 10, false, Climate.HOT.name, "environs:canyon", "none");
        this.coldPineTaiga = new BiomeSettings.Element((BiomeSettings)this, "Cold Pine Taiga", 10, false, Climate.SNOWY.name, "environs:cold_pine_taiga", "");
        this.coldPineTaigaM = new BiomeSettings.Element((BiomeSettings)this, "Cold Pine Taiga M", 3, false, Climate.SNOWY.name, "environs:cold_pine_taiga_m", "none");
        this.dryOakForest = new BiomeSettings.Element((BiomeSettings)this, "Dry Oak Forest", 10, false, Climate.HOT.name, "environs:dry_oak_forest", "");
        this.dryOakForestM = new BiomeSettings.Element((BiomeSettings)this, "Dry Oak Forest M", 3, false, Climate.HOT.name, "environs:dry_oak_forest_m", "none");
        this.emeraldCliffs = new BiomeSettings.Element((BiomeSettings)this, "Emerald Cliffs", 5, false, Climate.WARM.name, "environs:emerald_cliffs", "none");
        this.endForest = new BiomeSettings.Element((BiomeSettings)this, "End Forest", 5, false, Climate.COOL.name, "environs:end_forest", "none");
        this.floatingEndForest = new BiomeSettings.Element((BiomeSettings)this, "Floating End Forest", 2, false, Climate.COOL.name, "environs:floating_end_forest", "none");
        this.extremeJungle = new BiomeSettings.Element((BiomeSettings)this, "Extreme Jungle", 5, false, Climate.HOT.name);
        this.icyHills = new BiomeSettings.Element((BiomeSettings)this, "IcyHills", 10, false, Climate.SNOWY.name, "environs:icy_hills", "none");
        this.kakadu = new BiomeSettings.Element((BiomeSettings)this, "Kakadu", 5, false, Climate.HOT.name, "environs:kakadu", "");
        this.lushForest = new BiomeSettings.Element((BiomeSettings)this, "Lush Forest", 0, false, Climate.WARM.name, "environs:lush_forest", "");
        this.mushroomRainforests = new BiomeSettings.Element((BiomeSettings)this, "Mushroom Rainforest", 5, false, Climate.HOT.name, "environs:mushroom_rainforest", "none");
        this.overgrownPlains = new BiomeSettings.Element((BiomeSettings)this, "OvergrownPlains", 10, false, Climate.WARM.name, "environs:overgrown_plains", "");
        this.pineTaiga = new BiomeSettings.Element((BiomeSettings)this, "Pine Taiga", 10, false, Climate.COOL.name, "environs:pine_taiga", "");
        this.pineTaigaM = new BiomeSettings.Element((BiomeSettings)this, "Pine Taiga M", 3, false, Climate.COOL.name, "environs:pine_taiga_m", "none");
        this.roofedSwamp = new BiomeSettings.Element((BiomeSettings)this, "Roofed Swamp", 5, false, Climate.WARM.name, "environs:roofed_swamp", "none");
        this.sandstoneRanges = new BiomeSettings.Element((BiomeSettings)this, "Sandstone Ranges", 10, false, Climate.HOT.name, "environs:sandstone_ranges", "none");
        this.silkForest = new BiomeSettings.Element((BiomeSettings)this, "Silk Forest", 5, false, Climate.WARM.name, "environs:silk_wetland", "none");
        this.stoneBasin = new BiomeSettings.Element((BiomeSettings)this, "Stone Basin", 10, true, Climate.COOL.name, "environs:stone_basin", "minecraft:stone_beach");
        this.stoneHills = new BiomeSettings.Element((BiomeSettings)this, "Stone Hills", 3, false, Climate.COOL.name, "environs:stone_hills", "none");
        this.tallOakForest = new BiomeSettings.Element((BiomeSettings)this, "Tall Oak Forest", 10, false, Climate.WARM.name, "environs:tall_oak_forest", "");
        this.tallOakForestM = new BiomeSettings.Element((BiomeSettings)this, "Tall Oak Forest M", 3, false, Climate.WARM.name, "environs:tall_oak_forest_m", "none");
        this.tallOakWetlands = new BiomeSettings.Element((BiomeSettings)this, "Tall Oak Wetlands", 5, false, Climate.WARM.name, "environs:tall_oak_wetland", "none");
        this.wastelandEroded = new BiomeSettings.Element((BiomeSettings)this, "Eroded Wasteland", 3, false, Climate.HOT.name, "environs:wasteland_eroded", "none");
        this.wastelandSpikes = new BiomeSettings.Element((BiomeSettings)this, "Wasteland Spikes", 10, false, Climate.HOT.name, "environs:wasteland_spikes", "none");
        this.biomesFromConfig = this.climateControlCategory.booleanSetting(biomesOnName, "", false);
        this.biomesInNewWorlds = this.climateControlCategory.booleanSetting(this.startBiomesName(configName), "Use biome in new worlds and dimensions", true);
    }

    @Override
    public void setNativeBiomeIDs(File configDirectory) {
        super.setNativeBiomeIDs(configDirectory);
        this.confirm();
    }

    @Override
    public void onNewWorld() {
        this.biomesFromConfig.set(this.biomesInNewWorlds);
    }

    @Override
    public boolean biomesAreActive() {
        return this.biomesFromConfig.value();
    }
}

