/*
 * Decompiled with CFR 0.152.
 */
package climateControl.api;

import climateControl.api.BiomeSettings;
import climateControl.api.Climate;
import java.util.ArrayList;
import java.util.Collection;

public class ClimateDistribution {
    public static final ArrayList<ClimateDistribution> list = new ArrayList();
    private ArrayList<Climate> climates = new ArrayList();
    private final String name;
    public static ClimateDistribution SNOWY = new ClimateDistribution(Climate.SNOWY, "SNOWY");
    public static ClimateDistribution COOL = new ClimateDistribution(Climate.COOL, "COOL");
    public static ClimateDistribution WARM = new ClimateDistribution(Climate.WARM, "WARM");
    public static ClimateDistribution HOT = new ClimateDistribution(Climate.HOT, "HOT");
    public static ClimateDistribution MEDIUM = new ClimateDistribution(Climate.COOL, Climate.WARM, "MEDIUM");
    public static ClimateDistribution PLAINS = new ClimateDistribution(Climate.COOL, Climate.WARM, Climate.HOT, "PLAINS");
    public static ClimateDistribution OCEAN = new ClimateDistribution(Climate.OCEAN, "OCEAN");
    public static ClimateDistribution DEEP_OCEAN = new ClimateDistribution(Climate.DEEP_OCEAN, "DEEP_OCEAN");
    public static ClimateDistribution LAND = new ClimateDistribution(Climate.SNOWY, Climate.COOL, Climate.WARM, Climate.HOT, "LAND");
    public static ClimateDistribution SEA = new ClimateDistribution(Climate.OCEAN, Climate.DEEP_OCEAN, "SEA");
    public static ClimateDistribution SUBARCTIC = new ClimateDistribution(Climate.SNOWY, Climate.COOL, "SUBARCTIC");
    public static ClimateDistribution SUBTROPICAL = new ClimateDistribution(Climate.WARM, Climate.HOT, "SUBTROPICAL");

    public ClimateDistribution(Climate base, String name) {
        this.climates.add(base);
        this.name = name;
        list.add(this);
    }

    private ClimateDistribution(Climate one, Climate two, String name) {
        this.climates.add(one);
        this.climates.add(two);
        this.name = name;
        list.add(this);
    }

    private ClimateDistribution(Climate one, Climate two, Climate three, String name) {
        this.climates.add(one);
        this.climates.add(two);
        this.climates.add(three);
        this.name = name;
        list.add(this);
    }

    private ClimateDistribution(Climate one, Climate two, Climate three, Climate four, String name) {
        this.climates.add(one);
        this.climates.add(two);
        this.climates.add(three);
        this.climates.add(four);
        this.name = name;
        list.add(this);
    }

    public String name() {
        return this.name;
    }

    public Collection<Incidence> incidences(BiomeSettings.Element element) {
        ArrayList<Incidence> result = new ArrayList<Incidence>();
        int doneSoFar = 0;
        int remainingIncidence = element.biomeIncidences().value();
        for (Climate climate : this.climates) {
            int thisIncidence = remainingIncidence / (this.climates.size() - doneSoFar);
            ++doneSoFar;
            result.add(new Incidence(element.biomeID().value(), thisIncidence, climate));
            remainingIncidence -= thisIncidence;
        }
        return result;
    }

    public class Incidence {
        public final int biome;
        public final int incidence;
        public final Climate climate;

        private Incidence(int biome, int incidence, Climate climate) {
            this.biome = biome;
            this.incidence = incidence;
            this.climate = climate;
        }
    }
}

