/*
 * Decompiled with CFR 0.152.
 */
package climateControl.api;

import climateControl.api.BiomeSettings;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;

public class ClimateControlRules {
    private boolean[] riversDisallowed = new boolean[BiomeSettings.highestBiomeID() + 1];
    private boolean[] stoneBeachDisallowed = new boolean[BiomeSettings.highestBiomeID() + 1];
    private boolean[] hasVillages = new boolean[BiomeSettings.highestBiomeID() + 1];
    private int[] beachIDs = new int[BiomeSettings.highestBiomeID() + 1];
    private boolean moreComplexSubbiomes = false;

    public ClimateControlRules() {
        for (int i = 0; i < this.beachIDs.length; ++i) {
            this.beachIDs[i] = -1;
        }
    }

    public final boolean riversAllowed(int biomeID) {
        return !this.riversDisallowed[biomeID];
    }

    public final boolean riversDisallowed(int biomeID) {
        return this.riversDisallowed[biomeID];
    }

    public final boolean stoneBeachAllowed(int biomeID) {
        return !this.stoneBeachDisallowed[biomeID];
    }

    public final boolean stoneBeachDisallowed(int biomeID) {
        return this.stoneBeachDisallowed[biomeID];
    }

    public final boolean noBeachesAllowed(int biomeID) {
        return this.beachIDs[biomeID] == biomeID;
    }

    public final boolean beachesAllowed(int biomeID) {
        return !this.noBeachesAllowed(biomeID);
    }

    public final boolean hasVillages(int biomeID) {
        return this.hasVillages[biomeID];
    }

    public final boolean moreComplexSubbiomes() {
        return this.moreComplexSubbiomes;
    }

    public final void setComplexSubBiomes() {
        this.moreComplexSubbiomes = true;
    }

    public final Accessor biome(int biomeID) {
        return new Accessor(biomeID);
    }

    public void disallowRivers(int biomeID) {
        if (biomeID == -1) {
            return;
        }
        this.riversDisallowed[biomeID] = true;
    }

    public void allowVillages(int biomeID) {
        if (biomeID == -1) {
            return;
        }
        this.hasVillages[biomeID] = true;
    }

    public void disallowStoneBeach(int biomeID) {
        if (biomeID == -1) {
            return;
        }
        this.stoneBeachDisallowed[biomeID] = true;
    }

    public void noBeaches(int biomeID) {
        if (biomeID == -1) {
            return;
        }
        this.beachIDs[biomeID] = biomeID;
    }

    public int beachID(int biomeID, boolean hilly) {
        if (this.noBeachesAllowed(biomeID)) {
            return biomeID;
        }
        if (this.beachIDs[biomeID] == -1) {
            return this.calculatedBeachBiome(biomeID, hilly);
        }
        return this.beachIDs[biomeID];
    }

    private int calculatedBeachBiome(int k1, boolean hilly) {
        Biome biome = Biome.func_150568_d((int)k1);
        if (biome.func_150561_m() == Biome.TempCategory.COLD) {
            return Biome.func_185362_a((Biome)Biomes.field_150577_O);
        }
        if (hilly && this.stoneBeachAllowed(k1)) {
            return Biome.func_185362_a((Biome)Biomes.field_150576_N);
        }
        if (k1 != Biome.func_185362_a((Biome)Biomes.field_76789_p) && k1 != Biome.func_185362_a((Biome)Biomes.field_76788_q)) {
            return Biome.func_185362_a((Biome)Biomes.field_76787_r);
        }
        return Biome.func_185362_a((Biome)Biomes.field_76788_q);
    }

    public class Accessor {
        private final int biomeID;

        Accessor(int _biomeID) {
            this.biomeID = _biomeID;
        }

        public void setBeach(int beachID) {
            ((ClimateControlRules)ClimateControlRules.this).beachIDs[this.biomeID] = beachID;
        }
    }
}

