/*
 * Decompiled with CFR 0.152.
 */
package climateControl.api;

import climateControl.ClimateControl;
import climateControl.api.ClimateControlRules;
import climateControl.api.ClimateDistribution;
import climateControl.api.Logger;
import climateControl.biomeSettings.BiomeReplacer;
import climateControl.generator.BiomeSwapper;
import climateControl.generator.SubBiomeChooser;
import com.Zeno410Utils.Mutable;
import com.Zeno410Utils.Settings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public abstract class BiomeSettings
extends Settings {
    private final ArrayList<Element> elements = new ArrayList();
    private final ArrayList<ID> ids = new ArrayList();
    private final Settings.Category idCategory;
    private final Settings.Category incidenceCategory;
    private final Settings.Category namedIDCategory;
    private final Settings.Category villagesCategory;
    private final Settings.Category climateCategory;
    private final Settings.Category beachCategory;
    protected final Settings.Category climateControlCategory = this.category("Assorted Parameters");

    public static int extractBiomeID(String writtenBiomeTag) {
        String biomeTag = writtenBiomeTag.trim();
        if (biomeTag == "") {
            return -1;
        }
        for (ResourceLocation location : Biome.field_185377_q.func_148742_b()) {
            if (!location.toString().equals(biomeTag)) continue;
            return Biome.func_185362_a((Biome)((Biome)Biome.field_185377_q.func_82594_a((Object)location)));
        }
        if (biomeTag != null && !biomeTag.equalsIgnoreCase("none")) {
            Logger.debug("Could not find biome ID for {}", biomeTag);
        }
        return -1;
    }

    public static int highestBiomeID() {
        Iterator registries = Biome.field_185377_q.func_148742_b().iterator();
        int result = 256;
        while (registries.hasNext()) {
            ResourceLocation location = (ResourceLocation)registries.next();
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)location);
            int ID2 = Biome.field_185377_q.func_148757_b((Object)biome);
            result = Math.max(result, ID2);
        }
        return result;
    }

    public BiomeSettings(String categoryName) {
        this.idCategory = this.category(categoryName + "IDs");
        this.namedIDCategory = this.category(categoryName + "IDNames");
        this.incidenceCategory = this.category(categoryName + "Incidences");
        this.villagesCategory = this.category(categoryName + "Villages");
        this.climateCategory = this.category(categoryName + "Climates", "Climate Types are: SNOWY,COOL,WARM,HOT,OCEAN,DEEP_OCEAN,MEDIUM,SUBARCTIC,SUBTROPICAL,PLAINS,LAND, and SEA.  MEDIUM is COOL and WARM, SUBARCTIC is SNOWY and COOL, SUBTROPICAL is WARM and HOTPLAINS is COOL and WARM and HOT, LAND is all four land, SEA is both oceans");
        this.beachCategory = this.category(categoryName + "Beaches", "Use text biome identifiers, like minecraft:stone_beach. Use the biome's own identifier, or NONE, for no beach. Blank or DEFAULT will make Geographicraft choose a vanilla beach based on temperature and hilliness. Typos will produce an error message in the debug log and will then be treated as blank");
    }

    public ArrayList<Element> elements() {
        return this.elements;
    }

    public ArrayList<ID> ids() {
        return this.ids;
    }

    public void confirm() {
        this.confirm(new HashSet<Integer>());
    }

    public void confirm(Set<Integer> used) {
        for (ID id : this.ids) {
            if ((Integer)id.biomeID.value() < 0) {
                Logger.info(id.biomeIDName + " missing", new Object[0]);
                continue;
            }
            if (used.contains(id.biomeID.value())) {
                Logger.info(id.biomeIDName + " uses another biome's ID", new Object[0]);
            }
            used.add((Integer)id.biomeID.value());
        }
    }

    public boolean activeIn(WorldType worldType) {
        return true;
    }

    protected ID M(ID original, String name) {
        ID result = new ID(name, original.biomeID().value() + 128);
        original.setMBiome(result);
        return result;
    }

    protected ID M(ID original) {
        return this.M(original, original.name + " M");
    }

    public ArrayList<ClimateDistribution.Incidence> incidences() {
        ArrayList<ClimateDistribution.Incidence> result = new ArrayList<ClimateDistribution.Incidence>();
        for (Element element : this.elements) {
            ClimateControl.logger.info(element.name + " " + element.active() + " " + element.biomeIncidences().value());
            if (!element.active()) continue;
            try {
                result.addAll(element.distribution().incidences(element));
            }
            catch (NoTempSetting noTempSetting) {}
        }
        return result;
    }

    public void update(SubBiomeChooser subBiomeChooser) {
        for (ID id : this.ids) {
            if (!id.active()) continue;
            subBiomeChooser.set(id.biomeID().value(), id.subBiomeChooser);
        }
    }

    public void updateMBiomes(BiomeSwapper mBiomes) {
        for (ID id : this.ids) {
            if (id.MBiome == null) continue;
            mBiomes.set(id.biomeID().value(), id.MBiome.biomeID().value());
        }
    }

    protected ID externalBiome(String name, int biomeID) {
        return new ID(name, new Mutable.Concrete<Integer>(biomeID));
    }

    private void stripCategory(Settings.Category category, Configuration config) {
        ConfigCategory toRemove = config.getCategory(category.name.toLowerCase());
        config.removeCategory(toRemove);
        if (config.hasCategory(category.name.toLowerCase())) {
            throw new RuntimeException();
        }
    }

    private void stripFrom(Configuration config) {
        this.stripCategory(this.idCategory, config);
        this.stripCategory(this.incidenceCategory, config);
        this.stripCategory(this.villagesCategory, config);
        this.stripCategory(this.climateControlCategory, config);
        this.stripCategory(this.climateCategory, config);
    }

    public void stripIDsFrom(Configuration config) {
        this.stripCategory(this.idCategory, config);
    }

    @Override
    public void readForeignConfigs(File generalConfigDirectory) {
        this.setNativeBiomeIDs(generalConfigDirectory);
    }

    public void setRules(ClimateControlRules rules) {
        this.setVillages(rules);
        for (ID id : this.ids()) {
            if (!id.active()) continue;
            rules.biome(id.biomeID().value()).setBeach(id.beachID());
        }
    }

    public void setNativeBiomeIDs(File configDirectory) {
        for (ID id : this.ids()) {
            id.setID();
            if ((Integer)id.biomeID.value() >= 0) continue;
            Logger.debug("Biome problem with {}", id.name);
        }
    }

    public void setNativeBiomeIDs() {
        for (ID id : this.ids()) {
            id.setID();
            if ((Integer)id.biomeID.value() >= 0) continue;
            Logger.debug("Biome problem with {}", id.name);
        }
    }

    public abstract void onNewWorld();

    public String startBiomesName(String configName) {
        return configName + "InNewDimensons";
    }

    public void setVillages(ClimateControlRules rules) {
        for (ID id : this.ids) {
            if (!((Boolean)id.hasVillages.value()).booleanValue()) continue;
            rules.allowVillages((Integer)id.biomeID.value());
        }
    }

    public final boolean equalsByIdentity(BiomeSettings compared) {
        return super.equals(compared);
    }

    public abstract boolean biomesAreActive();

    public void report() {
    }

    public GenLayer subBiomeEdges(long seed, GenLayer parent, int biomeCount) {
        return parent;
    }

    public void arrangeInteractions(ArrayList<BiomeSettings> biomeSettings) {
    }

    public void nameDefaultClimates() {
        for (ID element : this.ids) {
            int biomeID;
            if (!element.climate.value().equalsIgnoreCase("DEFAULT") || (biomeID = element.biomeID().value().intValue()) < 0 || biomeID > 1024) continue;
            try {
                ClimateDistribution distribution = element.defaultDistribution();
                element.setDistribution(distribution);
            }
            catch (NoTempSetting noTempSetting) {}
        }
    }

    public class ID {
        private Mutable<Integer> biomeID;
        private Mutable<Boolean> hasVillages;
        protected final Mutable<String> climate;
        public final String name;
        protected String biomeIDName = "";
        protected final Mutable<String> beachName;
        private ID MBiome = null;
        private BiomeReplacer subBiomeChooser = BiomeReplacer.noChange;
        private ClimateDistribution distribution;

        public ID(String name, int ID2, boolean hasVillages, String climate) {
            this(name, this$0.idCategory.intSetting(name + " ID", ID2), hasVillages, climate, true);
        }

        public ID(String name, int ID2, boolean hasVillages) {
            this(name, ID2, hasVillages, "DEFAULT");
        }

        public ID(String name, int ID2) {
            this(name, ID2, false);
        }

        public ID(String name, Mutable<Integer> ID2, boolean hasVillages, String climate, boolean beachPossible) {
            this.name = name;
            this.biomeID = ID2;
            this.hasVillages = BiomeSettings.this.villagesCategory.booleanSetting(name + " hasVillages", hasVillages);
            this.climate = BiomeSettings.this.climateCategory.stringSetting(name + " climate", climate);
            BiomeSettings.this.ids.add(this);
            this.distribution = null;
            this.beachName = beachPossible ? BiomeSettings.this.beachCategory.stringSetting(name + " beach", "") : null;
        }

        public ID(String name, boolean hasVillages, String climate, String _biomeIDName, boolean beachPossible) {
            this.name = name;
            this.biomeID = BiomeSettings.this.idCategory.intSetting(name + " ID", -1);
            this.hasVillages = BiomeSettings.this.villagesCategory.booleanSetting(name + " hasVillages", hasVillages);
            this.climate = BiomeSettings.this.climateCategory.stringSetting(name + " climate", climate);
            BiomeSettings.this.ids.add(this);
            this.distribution = null;
            this.biomeIDName = _biomeIDName;
            this.beachName = beachPossible ? BiomeSettings.this.beachCategory.stringSetting(name + " beach", "") : null;
        }

        public ID(String name, boolean hasVillages, String climate, String _biomeIDName, String beachIDName) {
            this.name = name;
            this.biomeID = BiomeSettings.this.idCategory.intSetting(name + " ID", -1);
            this.hasVillages = BiomeSettings.this.villagesCategory.booleanSetting(name + " hasVillages", hasVillages);
            this.climate = BiomeSettings.this.climateCategory.stringSetting(name + " climate", climate);
            BiomeSettings.this.ids.add(this);
            this.distribution = null;
            this.biomeIDName = _biomeIDName;
            this.beachName = BiomeSettings.this.beachCategory.stringSetting(name + " beach", beachIDName);
        }

        public ID(String name, String _biomeIDName, String beachIDName) {
            this(name, false, "DEFAULT", _biomeIDName, beachIDName);
        }

        public ID(String name, String _biomeIDName, boolean beachPossible) {
            this(name, false, "DEFAULT", _biomeIDName, beachPossible);
        }

        public ID(String name, Mutable<Integer> ID2) {
            this(name, ID2, false, "DEFAULT", true);
        }

        public Mutable<Integer> biomeID() {
            return this.biomeID;
        }

        public void setMBiome(ID MBiome) {
            if (this.MBiome != null) {
                Logger.debug("accidental reset of M Biome for {}", this.name);
            }
            this.MBiome = MBiome;
        }

        public void setIDFrom(Biome biome) {
            try {
                if (Biome.func_150568_d((int)Biome.func_185362_a((Biome)biome)).equals(biome)) {
                    this.biomeID().set(Biome.func_185362_a((Biome)biome));
                } else {
                    this.biomeID().set(-1);
                }
            }
            catch (NullPointerException e) {
                this.biomeID().set(-1);
            }
            catch (IllegalStateException e) {
                this.biomeID().set(-1);
            }
        }

        public void setIDFrom(String biomeRegistryName) {
            this.biomeID().set(BiomeSettings.extractBiomeID(biomeRegistryName));
        }

        public void setID() {
            if (this.biomeIDName != "") {
                this.biomeID().set(BiomeSettings.extractBiomeID(this.biomeIDName));
            }
            if (this.biomeID().value() < 0) {
                Logger.debug("missing biome for {}", this.name);
            }
        }

        protected void setBeach(String defaultBeachName) {
            this.beachName.set(defaultBeachName);
        }

        public int beachID() {
            if (this.beachName == null) {
                return this.biomeID.value();
            }
            if (this.beachName.value().equalsIgnoreCase("none")) {
                return this.biomeID.value();
            }
            if (this.beachName.value().equalsIgnoreCase("default")) {
                return -1;
            }
            if (this.beachName.value() != "") {
                return BiomeSettings.extractBiomeID(this.beachName.value());
            }
            return -1;
        }

        public boolean active() {
            if (this.biomeID.value() < 0) {
                return false;
            }
            return Biome.func_150568_d((int)this.biomeID.value()) != null;
        }

        public BiomeReplacer subBiomeChooser() {
            return this.subBiomeChooser;
        }

        public void setSubBiomeChooser(BiomeReplacer subBiomeChooser) {
            this.subBiomeChooser = subBiomeChooser;
        }

        public void setSubBiome(ID subBiome) {
            if (subBiome.biomeID.value() < 1) {
                Logger.debug("biome {} not yet assigned ID", subBiome.name);
            }
            this.subBiomeChooser = new BiomeReplacer.Fixed(subBiome.biomeID.value());
        }

        private ClimateDistribution defaultDistribution() {
            Biome.TempCategory temp = null;
            try {
                temp = Biome.func_150568_d((int)this.biomeID().value()).func_150561_m();
                if (temp == Biome.TempCategory.COLD) {
                    return ClimateDistribution.SNOWY;
                }
                if (temp == Biome.TempCategory.MEDIUM) {
                    return ClimateDistribution.MEDIUM;
                }
                if (temp == Biome.TempCategory.WARM) {
                    return ClimateDistribution.HOT;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new NoTempSetting();
        }

        public void setDistribution(ClimateDistribution newDistribution) {
            this.distribution = newDistribution;
            this.climate.set(newDistribution.name());
        }

        public ClimateDistribution distribution() {
            if (this.distribution != null) {
                return this.distribution;
            }
            return this.configDistribution();
        }

        public ClimateDistribution configDistribution() {
            if (this.climate.value().equalsIgnoreCase("DEFAULT")) {
                return this.defaultDistribution();
            }
            if (this.climate.value().equalsIgnoreCase("")) {
                return this.defaultDistribution();
            }
            for (ClimateDistribution testedDistribution : ClimateDistribution.list) {
                if (!this.climate.value().equalsIgnoreCase(testedDistribution.name())) continue;
                return testedDistribution;
            }
            Logger.debug("Climate " + this.climate.value() + " not recognized", new Object[0]);
            return this.defaultDistribution();
        }
    }

    public class Element
    extends ID {
        private Mutable<Integer> biomeIncidence;

        public Element(String name, int incidence, boolean hasVillages, String climate, String _biomeIDName, boolean beachPossible) {
            super(name, hasVillages, climate, _biomeIDName, beachPossible);
            this.biomeIncidence = BiomeSettings.this.incidenceCategory.intSetting(name + " Incidence", incidence);
            this.biomeIncidence.set(incidence);
            BiomeSettings.this.elements.add(this);
        }

        public Element(String name, int incidence, boolean hasVillages, String climate, String _biomeIDName, String beachIDName) {
            super(name, hasVillages, climate, _biomeIDName, beachIDName);
            this.biomeIncidence = BiomeSettings.this.incidenceCategory.intSetting(name + " Incidence", incidence);
            this.biomeIncidence.set(incidence);
            BiomeSettings.this.elements.add(this);
        }

        public Element(String name, int incidence, boolean hasVillages, String climate, String _biomeIDName) {
            super(name, -1, hasVillages, climate);
            this.biomeIncidence = BiomeSettings.this.incidenceCategory.intSetting(name + " Incidence", incidence);
            this.biomeIncidence.set(incidence);
            this.biomeIDName = _biomeIDName;
            BiomeSettings.this.elements.add(this);
        }

        public Element(String name, int ID2, int incidence, boolean hasVillages, String climate) {
            super(name, ID2, hasVillages, climate);
            this.biomeIncidence = BiomeSettings.this.incidenceCategory.intSetting(name + " Incidence", incidence);
            this.biomeIncidence.set(incidence);
            BiomeSettings.this.elements.add(this);
        }

        public Element(String name, int ID2, int incidence, boolean hasVillages) {
            this(name, ID2, incidence, hasVillages, "DEFAULT");
        }

        public Element(String name, int ID2, int incidence, String climate) {
            this(name, ID2, incidence, false, climate);
        }

        public Element(String name, int ID2, int incidence) {
            this(name, ID2, incidence, false);
        }

        public Element(String name, int ID2) {
            this(name, ID2, 10, false);
        }

        public Element(String name, int ID2, String climate) {
            this(name, ID2, 10, false, climate);
        }

        public Element(String name, int ID2, boolean hasVillages) {
            this(name, ID2, 10, false);
        }

        public Element(String name, int ID2, boolean hasVillages, String climate) {
            this(name, ID2, 10, false, climate);
        }

        public Mutable<Integer> biomeIncidences() {
            return this.biomeIncidence;
        }
    }

    public class NoTempSetting
    extends RuntimeException {
    }

    public class ExternalElement
    extends Element {
        final Mutable<String> configurableBiomeName;

        public ExternalElement(String name, int incidence, boolean hasVillages, String climate, String _biomeIDName, String _beachIDName) {
            super(name, incidence, hasVillages, climate, _biomeIDName, _beachIDName);
            this.configurableBiomeName = BiomeSettings.this.namedIDCategory.stringSetting(name + " Biome ID Name", _biomeIDName);
        }

        @Override
        public void setID() {
            if (this.configurableBiomeName.value() != "") {
                this.biomeID().set(BiomeSettings.extractBiomeID(this.configurableBiomeName.value()));
            }
            if (this.biomeID().value() < 0) {
                Logger.debug("missing biome for " + this.name, new Object[0]);
            }
        }
    }
}

