/*
 * Decompiled with CFR 0.152.
 */
package climateControl.api;

import climateControl.api.BiomeSettings;
import climateControl.api.Climate;
import climateControl.api.ClimateDistribution;
import climateControl.api.IncidenceModifier;
import com.Zeno410Utils.IntRandomizer;
import com.Zeno410Utils.Numbered;
import com.Zeno410Utils.Zeno410Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;

public class BiomeRandomizer {
    public static Logger logger = new Zeno410Logger("BiomeRandomizer").logger();
    public BiomeList global;
    private BiomeList hot;
    private BiomeList warm;
    private BiomeList cool;
    private BiomeList snowy;
    private BiomeList ocean;
    private BiomeList deepOcean;

    private BiomeRandomizer() {
    }

    public BiomeRandomizer(Collection<BiomeSettings> settings) {
        this.global = new BiomeList();
        this.hot = new BiomeList();
        this.warm = new BiomeList();
        this.cool = new BiomeList();
        this.snowy = new BiomeList();
        this.ocean = new BiomeList();
        this.deepOcean = new BiomeList();
        for (BiomeSettings setting : settings) {
            if (!setting.biomesAreActive()) continue;
            for (ClimateDistribution.Incidence incidence : setting.incidences()) {
                this.add(incidence);
            }
        }
    }

    private BiomeList randomizer(Climate climate) {
        if (climate == Climate.DEEP_OCEAN) {
            return this.deepOcean;
        }
        if (climate == Climate.SNOWY) {
            return this.snowy;
        }
        if (climate == Climate.COOL) {
            return this.cool;
        }
        if (climate == Climate.WARM) {
            return this.warm;
        }
        if (climate == Climate.HOT) {
            return this.hot;
        }
        if (climate == Climate.OCEAN) {
            return this.ocean;
        }
        throw new RuntimeException("No such climate");
    }

    public int size() {
        return this.hot.biomes.length + this.ocean.biomes.length + this.deepOcean.biomes.length + this.snowy.biomes.length + this.cool.biomes.length + this.warm.biomes.length;
    }

    private void add(ClimateDistribution.Incidence incidence) {
        if (incidence.climate != Climate.DEEP_OCEAN && incidence.climate != Climate.OCEAN) {
            this.global.append(incidence.incidence, Biome.func_150568_d((int)incidence.biome));
        }
        this.randomizer(incidence.climate).append(incidence.incidence, Biome.func_150568_d((int)incidence.biome));
    }

    public PickByClimate pickByClimate() {
        return new PickByClimate();
    }

    private BiomeRandomizer modifiedBy(IncidenceModifier modifier) {
        if (this.ocean.biomes.length < 1) {
            throw new RuntimeException();
        }
        BiomeRandomizer result = new BiomeRandomizer();
        result.cool = this.cool.modifiedSubRandomizer(modifier);
        result.deepOcean = this.deepOcean.modifiedSubRandomizer(modifier);
        result.hot = this.hot.modifiedSubRandomizer(modifier);
        result.ocean = this.ocean.modifiedSubRandomizer(modifier);
        result.snowy = this.snowy.modifiedSubRandomizer(modifier);
        result.warm = this.warm.modifiedSubRandomizer(modifier);
        return result;
    }

    public class BiomeList {
        private Biome[] biomes = new Biome[0];
        private int nextIndex = 0;

        private void append(int count, Biome biome) {
            int lastIndex = this.nextIndex;
            Biome[] newArray = new Biome[this.nextIndex + count];
            for (int i = 0; i < lastIndex; ++i) {
                newArray[i] = this.biomes[i];
            }
            this.biomes = newArray;
            this.nextIndex = lastIndex;
            while (this.nextIndex < lastIndex + count) {
                this.biomes[this.nextIndex] = biome;
                ++this.nextIndex;
            }
        }

        public Biome choose(IntRandomizer source) {
            return this.biomes[source.nextInt(this.biomes.length)];
        }

        private BiomeList modifiedSubRandomizer(IncidenceModifier modifier) {
            BiomeList result = new BiomeList();
            for (Numbered<Biome> oldIncidence : this.incidences()) {
                int newIncidence = modifier.modifiedIncidence(oldIncidence);
                if (newIncidence <= 0) continue;
                result.append(newIncidence, oldIncidence.item());
            }
            return result;
        }

        private ArrayList<Numbered<Biome>> incidences() {
            ArrayList<Numbered<Biome>> result = new ArrayList<Numbered<Biome>>();
            Biome current = null;
            int occurances = 0;
            for (Biome biome : this.biomes) {
                if (biome == current) {
                    ++occurances;
                    continue;
                }
                if (occurances > 0) {
                    result.add(Numbered.from(occurances, current));
                    current = biome;
                    occurances = 1;
                }
                current = biome;
            }
            result.add(Numbered.from(occurances, current));
            return result;
        }
    }

    public class PickByClimate {
        public int biome(int climate, IntRandomizer source) {
            if (climate == 0) {
                return Biome.func_185362_a((Biome)BiomeRandomizer.this.ocean.choose(source));
            }
            if (climate == 1) {
                return Biome.func_185362_a((Biome)BiomeRandomizer.this.hot.choose(source));
            }
            if (climate == 2) {
                return Biome.func_185362_a((Biome)BiomeRandomizer.this.warm.choose(source));
            }
            if (climate == 3) {
                return Biome.func_185362_a((Biome)BiomeRandomizer.this.cool.choose(source));
            }
            if (climate == 4) {
                return Biome.func_185362_a((Biome)BiomeRandomizer.this.snowy.choose(source));
            }
            if (climate == Biome.func_185362_a((Biome)Biomes.field_150575_M)) {
                return Biome.func_185362_a((Biome)BiomeRandomizer.this.deepOcean.choose(source));
            }
            if (climate == Biome.func_185362_a((Biome)Biomes.field_76789_p)) {
                return climate;
            }
            return 0;
        }

        public boolean hasBiomes(int climate) {
            if (climate == 0) {
                return BiomeRandomizer.this.ocean.biomes.length > 0;
            }
            if (climate == 1) {
                return BiomeRandomizer.this.hot.biomes.length > 0;
            }
            if (climate == 2) {
                return BiomeRandomizer.this.warm.biomes.length > 0;
            }
            if (climate == 3) {
                return BiomeRandomizer.this.cool.biomes.length > 0;
            }
            if (climate == 4) {
                return BiomeRandomizer.this.snowy.biomes.length > 0;
            }
            if (climate == Biome.func_185362_a((Biome)Biomes.field_150575_M)) {
                return BiomeRandomizer.this.deepOcean.biomes.length > 0;
            }
            return false;
        }

        public HashMap<IncidenceModifier, PickByClimate> modifiedDistributions(ArrayList<IncidenceModifier> comprehensiveModifiers) {
            HashMap<IncidenceModifier, PickByClimate> result = new HashMap<IncidenceModifier, PickByClimate>();
            ArrayList<BiomeRandomizer> randomizers = new ArrayList<BiomeRandomizer>();
            for (IncidenceModifier modifier : comprehensiveModifiers) {
                logger.info(modifier.toString());
                BiomeRandomizer randomizer = BiomeRandomizer.this.modifiedBy(modifier);
                result.put(modifier, randomizer.pickByClimate());
                randomizers.add(randomizer);
            }
            for (BiomeRandomizer randomizer : randomizers) {
                if (randomizer.ocean.biomes.length == 0) {
                    for (BiomeRandomizer changed : randomizers) {
                        changed.ocean = BiomeRandomizer.this.ocean;
                    }
                }
                if (randomizer.cool.biomes.length == 0) {
                    for (BiomeRandomizer changed : randomizers) {
                        changed.cool = BiomeRandomizer.this.cool;
                    }
                }
                if (randomizer.deepOcean.biomes.length == 0) {
                    for (BiomeRandomizer changed : randomizers) {
                        changed.deepOcean = BiomeRandomizer.this.deepOcean;
                    }
                }
                if (randomizer.hot.biomes.length == 0) {
                    for (BiomeRandomizer changed : randomizers) {
                        changed.hot = BiomeRandomizer.this.hot;
                    }
                }
                if (randomizer.snowy.biomes.length == 0) {
                    for (BiomeRandomizer changed : randomizers) {
                        changed.snowy = BiomeRandomizer.this.snowy;
                    }
                }
                if (randomizer.warm.biomes.length != 0) continue;
                for (BiomeRandomizer changed : randomizers) {
                    changed.warm = BiomeRandomizer.this.warm;
                }
            }
            return result;
        }
    }
}

