/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.zoesteria;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.world.RTGWorld;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.zoesteria.RealisticBiomeZOEBase;

public class RealisticBiomeZOEForestedCanyonPlateauM
extends RealisticBiomeZOEBase {
    public RealisticBiomeZOEForestedCanyonPlateauM(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().SURFACE_WATER_LAKE_MULT.set(0.0f);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaSavannaPlateau(true, 35.0f, 160.0f, 60.0f, 40.0f, 69.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaSavannaPlateau(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, 0);
    }

    public class SurfaceVanillaSavannaPlateau
    extends SurfaceBase {
        private int grassRaise;
        private final IBlockState mixBlock;

        public SurfaceVanillaSavannaPlateau(BiomeConfig config, IBlockState top, IBlockState fill, int grassHeight) {
            super(config, top, fill);
            this.grassRaise = 0;
            this.grassRaise = grassHeight;
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), top);
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.3f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (k > 74 + this.grassRaise) {
                    if (depth == 0) {
                        if (rand.nextInt(5) == 0) {
                            primer.func_177855_a(x, k, z, this.mixBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (depth >= 4) continue;
                    primer.func_177855_a(x, k, z, this.fillerBlock);
                    continue;
                }
                if (depth == 0 && k > 61) {
                    int r = (int)((float)(k - (62 + this.grassRaise)) / 2.0f);
                    if (rand.nextInt(r + 2) == 0) {
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (rand.nextInt((int)((float)r / 2.0f) + 2) == 0) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainVanillaSavannaPlateau
    extends TerrainBase {
        private final boolean booRiver;
        private final float[] height = new float[]{12.0f, 0.5f, 6.0f, 0.7f};
        private final int heightLength = this.height.length;
        private final float strength;
        private float smooth;
        private float cWidth;
        private float cHeigth;
        private float cStrength;
        private float base;

        public TerrainVanillaSavannaPlateau(boolean riverGen, float heightStrength, float canyonWidth, float canyonHeight, float canyonStrength, float baseHeight) {
            this.booRiver = true;
            this.strength = 10.0f;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaSavannaPlateau.terrainPlateau(x, y, rtgWorld, river, this.height, border, this.strength, this.heightLength, 50.0f, true);
        }
    }
}

