/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.zoesteria;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.zoesteria.RealisticBiomeZOEBase;

public class RealisticBiomeZOEBluff
extends RealisticBiomeZOEBase {
    public RealisticBiomeZOEBluff(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPOvergrownCliffs(300.0f, 100.0f, 0.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPOvergrownCliffs(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B, 0.95f);
    }

    public static class SurfaceBOPOvergrownCliffs
    extends SurfaceBase {
        private final float min;
        private float sCliff = 3.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float cCliff = 3.5f;

        public SurfaceBOPOvergrownCliffs(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff) {
            super(config, top, fill);
            this.min = minCliff;
        }

        public SurfaceBOPOvergrownCliffs(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float clayCliff) {
            this(config, top, fill, minCliff);
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.cCliff = clayCliff;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPOvergrownCliffs
    extends TerrainBase {
        private final float width;
        private final float strength;
        private final float lakeDepth;
        private final float lakeWidth;
        private final float terrainHeight;

        public TerrainBOPOvergrownCliffs(float mountainWidth, float mountainStrength, float depthLake) {
            this(mountainWidth, mountainStrength, depthLake, 260.0f, 68.0f);
        }

        public TerrainBOPOvergrownCliffs(float mountainWidth, float mountainStrength, float depthLake, float widthLake, float height) {
            this.width = mountainWidth;
            this.strength = mountainStrength;
            this.lakeDepth = depthLake;
            this.lakeWidth = widthLake;
            this.terrainHeight = height;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPOvergrownCliffs.terrainLonelyMountain(x, y, rtgWorld, river, this.strength, this.width, this.terrainHeight);
        }
    }
}

