/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.collection.DecoCollectionTaiga;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeVanillaTaiga
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_76768_g;
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeVanillaTaiga() {
        super(biome, RealisticBiomeBase.BeachType.STONE);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_VILLAGES.set(true);
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaTaiga();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaTaiga(this.getConfig(), RealisticBiomeVanillaTaiga.biome.field_76752_A, RealisticBiomeVanillaTaiga.biome.field_76753_B);
    }

    @Override
    public void initDecos() {
        this.addDecoCollection(new DecoCollectionTaiga(this.getConfig(), 10.0f));
    }

    public static class SurfaceVanillaTaiga
    extends SurfaceBase {
        private final IBlockState mixBlock;

        public SurfaceVanillaTaiga(BiomeConfig config, IBlockState top, IBlockState fill) {
            super(config, top, fill);
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), BlockUtil.getStateDirt(BlockDirt.DirtType.PODZOL));
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float p = simplex.noise2f((float)i / 8.0f, (float)j / 8.0f) * 0.5f;
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    if (c > 0.45f && c > 1.5f - ((float)k - 60.0f) / 65.0f + p) {
                        cliff = 1;
                    }
                    if (c > 1.5f) {
                        cliff = 2;
                    }
                    if ((float)k > 110.0f + p * 4.0f && c < 0.3f + ((float)k - 100.0f) / 50.0f + p) {
                        cliff = 3;
                    }
                    if (cliff == 1) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 2) {
                        primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                        continue;
                    }
                    if (cliff == 3) {
                        primer.func_177855_a(x, k, z, Blocks.field_150433_aE.func_176223_P());
                        continue;
                    }
                    if (simplex.noise2f((float)i / 50.0f, (float)j / 50.0f) + p * 0.6f > 0.24f) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, Blocks.field_150349_c.func_176223_P());
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 2) {
                    primer.func_177855_a(x, k, z, this.getShadowStoneBlock());
                    continue;
                }
                if (cliff == 3) {
                    primer.func_177855_a(x, k, z, Blocks.field_150433_aE.func_176223_P());
                    continue;
                }
                primer.func_177855_a(x, k, z, Blocks.field_150346_d.func_176223_P());
            }
        }
    }

    public static class TerrainVanillaTaiga
    extends TerrainBase {
        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaTaiga.terrainFlatLakes(x, y, rtgWorld, river, 68.0f);
        }
    }
}

