/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.util.PlateauUtil;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.DecoBoulder;
import rtg.api.world.deco.DecoCactus;
import rtg.api.world.deco.DecoDoubleGrass;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.deco.DecoTree;
import rtg.api.world.deco.collection.DecoCollectionDesertRiver;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGAcaciaBucheri;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeVanillaSavannaPlateauM
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_185436_ah;
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeVanillaSavannaPlateauM() {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().SURFACE_WATER_LAKE_MULT.set(0.0f);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().addProperty(this.getConfig().ALLOW_CACTUS).set(true);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
        this.getConfig().addProperty(this.getConfig().ALLOW_PLATEAU_MODIFICATIONS).set(true);
        this.getConfig().addProperty(this.getConfig().PLATEAU_GRADIENT_BLOCK_LIST).set((Comparable[])PlateauUtil.getSavannaPlateauBlocks());
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaSavannaPlateauM(true, 35.0f, 160.0f, 60.0f, 40.0f, 69.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceVanillaSavannaPlateauM(this.getConfig(), RealisticBiomeVanillaSavannaPlateauM.biome.field_76752_A, RealisticBiomeVanillaSavannaPlateauM.biome.field_76753_B, 0);
    }

    @Override
    public void initDecos() {
        this.addDecoCollection(new DecoCollectionDesertRiver(this.getConfig()));
        DecoBoulder decoBoulder1 = new DecoBoulder();
        decoBoulder1.setBoulderBlock(Blocks.field_150347_e.func_176223_P());
        decoBoulder1.setMaxY(80);
        decoBoulder1.setChance(24);
        this.addDeco(decoBoulder1);
        DecoBoulder decoBoulder2 = new DecoBoulder();
        decoBoulder2.setBoulderBlock(Blocks.field_150347_e.func_176223_P());
        decoBoulder1.setMinY(110);
        decoBoulder2.setChance(24);
        this.addDeco(decoBoulder2);
        DecoShrub acaciaShrub = new DecoShrub();
        acaciaShrub.setLogBlock(Blocks.field_150363_s.func_176223_P());
        acaciaShrub.setLeavesBlock(Blocks.field_150361_u.func_176223_P());
        acaciaShrub.setMaxY(160);
        acaciaShrub.setLoopMultiplier(3.0f);
        acaciaShrub.setChance(9);
        this.addDeco(acaciaShrub);
        TreeRTGAcaciaBucheri acaciaTree = new TreeRTGAcaciaBucheri();
        acaciaTree.setLogBlock(Blocks.field_150363_s.func_176223_P());
        acaciaTree.setLeavesBlock(Blocks.field_150361_u.func_176223_P());
        acaciaTree.setMinTrunkSize(12);
        acaciaTree.setMaxTrunkSize(16);
        this.addTree(acaciaTree);
        DecoTree acaciaTrees = new DecoTree(acaciaTree);
        acaciaTrees.setStrengthFactorForLoops(2.0f);
        acaciaTrees.setTreeType(DecoTree.TreeType.RTG_TREE);
        acaciaTrees.setTreeCondition(DecoTree.TreeCondition.RANDOM_CHANCE);
        acaciaTrees.setTreeConditionChance(12);
        acaciaTrees.setMaxY(90);
        this.addDeco(acaciaTrees);
        DecoCactus decoCactus = new DecoCactus();
        decoCactus.setMaxY(160);
        decoCactus.setLoops(60);
        decoCactus.setChance(8);
        this.addDeco(decoCactus, this.getConfig().ALLOW_CACTUS.get());
        DecoDoubleGrass decoDoubleGrass = new DecoDoubleGrass();
        decoDoubleGrass.setMaxY(128);
        decoDoubleGrass.setStrengthFactor(3.0f);
        this.addDeco(decoDoubleGrass);
    }

    @Override
    public void overrideDecorations() {
        this.baseBiome().field_76760_I.field_76800_F = -999;
    }

    public class SurfaceVanillaSavannaPlateauM
    extends SurfaceBase {
        private int grassRaise;
        private final IBlockState mixBlock;

        public SurfaceVanillaSavannaPlateauM(BiomeConfig config, IBlockState top, IBlockState fill, int grassHeight) {
            super(config, top, fill);
            this.grassRaise = 0;
            this.grassRaise = grassHeight;
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), BlockUtil.getStateDirt(BlockDirt.DirtType.COARSE_DIRT));
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.3f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    primer.func_177855_a(x, k, z, PlateauUtil.getPlateauBand(rtgWorld, RealisticBiomeVanillaSavannaPlateauM.this, i, k, j));
                    continue;
                }
                if (k > 74 + this.grassRaise) {
                    if (depth == 0) {
                        if (rand.nextInt(5) == 0) {
                            primer.func_177855_a(x, k, z, this.mixBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (depth >= 4) continue;
                    primer.func_177855_a(x, k, z, this.fillerBlock);
                    continue;
                }
                if (depth == 0 && k > 61) {
                    int r = (int)((float)(k - (62 + this.grassRaise)) / 2.0f);
                    if (rand.nextInt(r + 2) == 0) {
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    if (rand.nextInt((int)((float)r / 2.0f) + 2) == 0) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainVanillaSavannaPlateauM
    extends TerrainBase {
        private final float[] height = new float[]{18.0f, 0.4f, 12.0f, 0.6f, 8.0f, 0.8f};
        private final int heightLength = this.height.length;
        private final float strength;

        public TerrainVanillaSavannaPlateauM(boolean riverGen, float heightStrength, float canyonWidth, float canyonHeight, float canyonStrength, float baseHeight) {
            this.strength = 10.0f;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaSavannaPlateauM.terrainPlateau(x, y, rtgWorld, river, this.height, border, this.strength, this.heightLength, 50.0f, true);
        }
    }
}

