/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeVanillaIceMountains
extends RealisticBiomeBase {
    public static Biome biome = Biomes.field_76775_o;
    public static Biome river = Biomes.field_76777_m;

    public RealisticBiomeVanillaIceMountains() {
        super(biome, RealisticBiomeBase.RiverType.FROZEN, RealisticBiomeBase.BeachType.COLD);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().addProperty(this.getConfig().USE_ARCTIC_SURFACE).set(true);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_FILLER_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaIceMountains(230.0f, 60.0f, 68.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        if (this.getConfig().USE_ARCTIC_SURFACE.get()) {
            return new SurfaceVanillaIceMountains(this.getConfig(), Blocks.field_150433_aE.func_176223_P(), Blocks.field_150433_aE.func_176223_P(), Blocks.field_150433_aE.func_176223_P(), Blocks.field_150433_aE.func_176223_P(), Blocks.field_150403_cj.func_176223_P(), Blocks.field_150432_aD.func_176223_P(), 60.0f, -0.14f, 14.0f, 0.25f);
        }
        return new SurfaceVanillaIceMountains(this.getConfig(), RealisticBiomeVanillaIceMountains.biome.field_76752_A, RealisticBiomeVanillaIceMountains.biome.field_76753_B, Blocks.field_150433_aE.func_176223_P(), Blocks.field_150433_aE.func_176223_P(), Blocks.field_150403_cj.func_176223_P(), Blocks.field_150432_aD.func_176223_P(), 60.0f, -0.14f, 14.0f, 0.25f);
    }

    @Override
    public void initDecos() {
    }

    public static class SurfaceVanillaIceMountains
    extends SurfaceBase {
        private final IBlockState mixBlockTop;
        private final IBlockState mixBlockFill;
        private final IBlockState cliffBlock1;
        private final IBlockState cliffBlock2;
        private final float width;
        private final float height;
        private final float smallW;
        private final float smallS;

        public SurfaceVanillaIceMountains(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFill, IBlockState cliff1, IBlockState cliff2, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.mixBlockTop = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), mixTop);
            this.mixBlockFill = this.getConfigBlock(config.SURFACE_MIX_FILLER_BLOCK.get(), mixFill);
            this.cliffBlock1 = cliff1;
            this.cliffBlock2 = cliff2;
            this.width = mixWidth;
            this.height = mixHeight;
            this.smallW = smallWidth;
            this.smallS = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            boolean mix = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        primer.func_177855_a(x, k, z, rand.nextInt(3) == 0 ? this.cliffBlock2 : this.cliffBlock1);
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.cliffBlock1);
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.width, (float)j / this.width) + simplex.noise2f((float)i / this.smallW, (float)j / this.smallW) * this.smallS > this.height) {
                        primer.func_177855_a(x, k, z, this.mixBlockTop);
                        mix = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                if (mix) {
                    primer.func_177855_a(x, k, z, this.mixBlockFill);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainVanillaIceMountains
    extends TerrainBase {
        private final float width;
        private final float strength;
        private final float terrainHeight;

        public TerrainVanillaIceMountains(float mountainWidth, float mountainStrength, float height) {
            this.width = mountainWidth;
            this.strength = mountainStrength;
            this.terrainHeight = height;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainVanillaIceMountains.terrainLonelyMountain(x, y, rtgWorld, river, this.strength, this.width, this.terrainHeight);
        }
    }
}

