/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.subaquatic;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.deco.collection.DecoCollectionOcean;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeSubaquaticWarmOcean
extends RealisticBiomeBase {
    public RealisticBiomeSubaquaticWarmOcean(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().SURFACE_WATER_LAKE_MULT.set(0.0f);
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().addProperty(this.getConfig().ALLOW_SPONGE).set(true);
        this.getConfig().addProperty(this.getConfig().SURFACE_MIX_BLOCK).set("");
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainSubaquaticWarmOcean();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceSubaquaticWarmOcean(this.getConfig(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150351_n.func_176223_P(), 20.0f, 0.2f);
    }

    @Override
    public void initDecos() {
        this.addDecoCollection(new DecoCollectionOcean(this.getConfig()));
    }

    public static class SurfaceSubaquaticWarmOcean
    extends SurfaceBase {
        private final IBlockState mixBlock;
        private final float width;
        private final float height;
        private float mixCheck;

        public SurfaceSubaquaticWarmOcean(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mix, float mixWidth, float mixHeight) {
            super(config, top, filler);
            this.mixBlock = this.getConfigBlock(config.SURFACE_MIX_BLOCK.get(), mix);
            this.width = mixWidth;
            this.height = mixHeight;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0 && k > 0 && k < 63) {
                    this.mixCheck = simplex.noise2f((float)i / this.width, (float)j / this.width);
                    if (this.mixCheck > this.height) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth < 4 && k < 63) {
                    primer.func_177855_a(x, k, z, this.fillerBlock);
                    continue;
                }
                if (depth != 0 || k >= 69) continue;
                primer.func_177855_a(x, k, z, Blocks.field_150354_m.func_176223_P());
            }
        }
    }

    public static class TerrainSubaquaticWarmOcean
    extends TerrainBase {
        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainSubaquaticWarmOcean.terrainOcean(x, y, rtgWorld, river, 60.0f);
        }
    }
}

