/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.subaquatic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeSubaquaticDeepWarmOcean
extends RealisticBiomeBase {
    public RealisticBiomeSubaquaticDeepWarmOcean(Biome biome) {
        super(biome);
    }

    @Override
    public void initDecos() {
    }

    @Override
    public void initConfig() {
        this.getConfig().SURFACE_WATER_LAKE_MULT.set(0.0f);
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainSubaquaticDeepWarmOcean(false, -10.0f, 8.0f, 0.0f, 0.0f, 30.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceSubaquaticDeepWarmOcean(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B);
    }

    public static class SurfaceSubaquaticDeepWarmOcean
    extends SurfaceBase {
        public SurfaceSubaquaticDeepWarmOcean(BiomeConfig config, IBlockState top, IBlockState filler) {
            super(config, top, filler);
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainSubaquaticDeepWarmOcean
    extends TerrainBase {
        private final boolean booRiver;
        private final float[] height;
        private final int heightLength;
        private final float strength;
        private final float cWidth;
        private final float cHeigth;
        private final float cStrength;
        private final float base;

        public TerrainSubaquaticDeepWarmOcean(boolean riverGen, float heightStrength, float canyonWidth, float canyonHeight, float canyonStrength, float baseHeight) {
            this.booRiver = riverGen;
            this.height = new float[]{5.0f, 0.5f, 12.5f, 0.5f};
            this.strength = heightStrength;
            this.heightLength = this.height.length;
            this.cWidth = canyonWidth;
            this.cHeigth = canyonHeight;
            this.cStrength = canyonStrength;
            this.base = baseHeight;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainSubaquaticDeepWarmOcean.terrainOceanCanyon(x, y, rtgWorld, river, this.height, border, this.strength, this.heightLength, this.booRiver);
        }
    }
}

