/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.fyrecraft;

import net.minecraft.world.biome.Biome;
import rtg.api.world.RTGWorld;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.HeightEffect;
import rtg.api.world.terrain.heighteffect.JitterEffect;
import rtg.api.world.terrain.heighteffect.MountainsWithPassesEffect;
import rtg.world.biome.realistic.fyrecraft.RealisticBiomeFYREBase;

public class RealisticBiomeFYREMegaMountains
extends RealisticBiomeFYREBase {
    public RealisticBiomeFYREMegaMountains(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPMountainPeaks(120.0f, 100.0f);
    }

    public static class TerrainBOPMountainPeaks
    extends TerrainBase {
        private final float width;
        private final float strength;
        private final float terrainHeight;
        private final float spikeWidth = 30.0f;
        private final float spikeHeight = 50.0f;
        private HeightEffect heightEffect;

        public TerrainBOPMountainPeaks(float mountainWidth, float mountainStrength) {
            this(mountainWidth, mountainStrength, 90.0f);
        }

        public TerrainBOPMountainPeaks(float mountainWidth, float mountainStrength, float height) {
            this.width = mountainWidth;
            this.strength = mountainStrength;
            this.terrainHeight = height;
            MountainsWithPassesEffect mountainEffect = new MountainsWithPassesEffect();
            mountainEffect.mountainHeight = this.strength;
            mountainEffect.mountainWavelength = this.width;
            mountainEffect.spikeHeight = this.spikeHeight;
            mountainEffect.spikeWavelength = this.spikeWidth;
            this.heightEffect = new JitterEffect(7.0f, 10.0f, mountainEffect);
            this.heightEffect = new JitterEffect(3.0f, 6.0f, this.heightEffect);
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPMountainPeaks.riverized(this.heightEffect.added(rtgWorld, x, y) + this.terrainHeight, river);
        }
    }
}

