/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeBOPColdDesert
extends RealisticBiomeBase {
    public RealisticBiomeBOPColdDesert(Biome biome) {
        super(biome, RealisticBiomeBase.RiverType.FROZEN, RealisticBiomeBase.BeachType.COLD);
    }

    @Override
    public void initDecos() {
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPColdDesert();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPColdDesert(this.getConfig(), Blocks.field_150433_aE.func_176223_P(), this.baseBiome().field_76753_B, Blocks.field_150433_aE.func_176223_P(), this.baseBiome().field_76753_B, 80.0f, -0.15f, 10.0f, 0.5f);
    }

    public static class SurfaceBOPColdDesert
    extends SurfaceBase {
        private final IBlockState blockMixTop;
        private final IBlockState blockMixFiller;
        private final float floMixWidth;
        private final float floMixHeight;
        private final float floSmallWidth;
        private final float floSmallStrength;

        public SurfaceBOPColdDesert(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFiller, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.blockMixTop = mixTop;
            this.blockMixFiller = mixFiller;
            this.floMixWidth = mixWidth;
            this.floMixHeight = mixHeight;
            this.floSmallWidth = smallWidth;
            this.floSmallStrength = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            boolean water = false;
            boolean riverPaint = false;
            boolean grass = false;
            if (river > 0.05f && river + simplex.noise2f((float)i / 10.0f, (float)j / 10.0f) * 0.1f > 0.86f) {
                riverPaint = true;
                if (simplex.noise2f((float)i / 12.0f, (float)j / 12.0f) > 0.25f) {
                    grass = true;
                }
            }
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b == Blocks.field_150348_b) {
                    ++depth;
                    if (riverPaint) {
                        if (grass && depth < 4) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        if (depth != 0) continue;
                        if (rand.nextInt(2) == 0) {
                            primer.func_177855_a(x, k, z, this.hcStone());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcCobble());
                        continue;
                    }
                    if (depth <= -1 || depth >= 9) continue;
                    primer.func_177855_a(x, k, z, this.topBlock);
                    if (depth != 0 || k <= 61 || k >= 254) continue;
                    TerrainBase.calcSnowHeight(x, k, z, primer, noise);
                    continue;
                }
                if (water || b != Blocks.field_150355_j) continue;
                primer.func_177855_a(x, k, z, Blocks.field_150432_aD.func_176223_P());
                water = true;
            }
        }
    }

    public static class TerrainBOPColdDesert
    extends TerrainBase {
        private final float ruggedness = 3.0f;
        private final float ruggednessWavelength = 100.0f;
        private final float heightPitch = 35.0f;
        private final float heightDivisor = 1.0f;

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            float result = TerrainBOPColdDesert.terrainPlains(x, y, rtgWorld, river, 100.0f, 3.0f, 35.0f, 1.0f, this.base);
            return result > this.base ? result : this.base;
        }
    }
}

