/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.HeightVariation;
import rtg.api.world.terrain.heighteffect.HillockEffect;

public class RealisticBiomeBOPBog
extends RealisticBiomeBase {
    public RealisticBiomeBOPBog(Biome biome) {
        super(biome);
    }

    @Override
    public void initDecos() {
    }

    @Override
    public Biome preferredBeach() {
        return (Biome)BOPBiomes.gravel_beach.orNull();
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPBog();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPBog(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B);
    }

    public static class SurfaceBOPBog
    extends SurfaceBase {
        public SurfaceBOPBog(BiomeConfig config, IBlockState top, IBlockState filler) {
            super(config, top, filler);
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPBog
    extends TerrainBase {
        private final float bottom = 62.0f;
        private final HeightVariation bottomVariation = new HeightVariation();
        private final HillockEffect smallHills;
        private final HillockEffect mediumHills;

        public TerrainBOPBog() {
            this.bottomVariation.height = 2.0f;
            this.bottomVariation.octave = 0;
            this.bottomVariation.wavelength = 40.0f;
            this.smallHills = new HillockEffect();
            this.smallHills.height = 5.0f;
            this.smallHills.wavelength = 25.0f;
            this.smallHills.minimumSimplex = 0.2f;
            this.smallHills.octave = 1;
            this.mediumHills = new HillockEffect();
            this.mediumHills.height = 10.0f;
            this.mediumHills.wavelength = 40.0f;
            this.mediumHills.minimumSimplex = 0.2f;
            this.mediumHills.octave = 2;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            float increment = this.bottomVariation.added(rtgWorld, x, y) + this.smallHills.added(rtgWorld, x, y);
            return TerrainBOPBog.riverized(62.0f + (increment += this.mediumHills.added(rtgWorld, x, y)), river);
        }
    }
}

